/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.mapred.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTableSnapshotInputFormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTableSnapshotInputFormatUtil.class);
    private static final String TABLESNAPSHOTINPUTFORMAT_CLASS = "org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl";
    private static final String TABLESNAPSHOTREGIONSPLIT_CLASS = "org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit";
    private static final boolean SUPPORTS_TABLE_SNAPSHOTS;

    public static void assertSupportsTableSnapshots() {
        if (!SUPPORTS_TABLE_SNAPSHOTS) {
            throw new RuntimeException("This version of HBase does not support Hive over table snapshots. Please upgrade to at least HBase 0.98.3 or later. See HIVE-6584 for details.");
        }
    }

    public static void configureJob(Configuration conf, String snapshotName, Path restoreDir) throws IOException {
        TableSnapshotInputFormatImpl.setInput((Configuration)conf, (String)snapshotName, (Path)restoreDir);
    }

    public static InputSplit createTableSnapshotRegionSplit() {
        try {
            HBaseTableSnapshotInputFormatUtil.assertSupportsTableSnapshots();
        }
        catch (RuntimeException e) {
            LOG.debug("Probably don't support table snapshots. Returning null instance.", (Throwable)e);
            return null;
        }
        try {
            Class<?> resultType = Class.forName(TABLESNAPSHOTREGIONSPLIT_CLASS);
            Constructor<?> cxtor = resultType.getDeclaredConstructor(new Class[0]);
            cxtor.setAccessible(true);
            return (InputSplit)cxtor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit", e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit", e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit", e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit", e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat$TableSnapshotRegionSplit", e);
        }
    }

    static {
        boolean support = false;
        try {
            Class<?> clazz = Class.forName(TABLESNAPSHOTINPUTFORMAT_CLASS);
            support = clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SUPPORTS_TABLE_SNAPSHOTS = support;
    }
}

