/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.jersey.server;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kudu.shaded.io.micrometer.core.annotation.Timed;
import org.apache.kudu.shaded.io.micrometer.core.annotation.TimedSet;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.jersey.server.AnnotationFinder;

class TimedFinder {
    private final AnnotationFinder annotationFinder;

    TimedFinder(AnnotationFinder annotationFinder) {
        this.annotationFinder = annotationFinder;
    }

    Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        Timed t2 = this.annotationFinder.findAnnotation(element, Timed.class);
        if (t2 != null) {
            return Collections.singleton(t2);
        }
        TimedSet ts = this.annotationFinder.findAnnotation(element, TimedSet.class);
        if (ts != null) {
            return Arrays.stream(ts.value()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

