/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.recordlevel.FilteringPrimitiveConverter;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;

public class FilteringGroupConverter
extends GroupConverter {
    private final GroupConverter delegate;
    private final List<Integer> indexFieldPath;
    private final Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn;
    private final Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath;

    public FilteringGroupConverter(GroupConverter delegate, List<Integer> indexFieldPath, Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn, Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        this.indexFieldPath = Objects.requireNonNull(indexFieldPath, "indexFieldPath cannot be null");
        this.columnIOsByIndexFieldPath = Objects.requireNonNull(columnIOsByIndexFieldPath, "columnIOsByIndexFieldPath cannot be null");
        this.valueInspectorsByColumn = Objects.requireNonNull(valueInspectorsByColumn, "valueInspectorsByColumn cannot be null");
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        Converter delegateConverter = Objects.requireNonNull(this.delegate.getConverter(fieldIndex), "delegate converter cannot be null");
        ArrayList<Integer> newIndexFieldPath = new ArrayList<Integer>(this.indexFieldPath.size() + 1);
        newIndexFieldPath.addAll(this.indexFieldPath);
        newIndexFieldPath.add(fieldIndex);
        if (delegateConverter.isPrimitive()) {
            PrimitiveColumnIO columnIO = this.getColumnIO(newIndexFieldPath);
            ColumnPath columnPath = ColumnPath.get(columnIO.getColumnDescriptor().getPath());
            IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors = this.getValueInspectors(columnPath);
            return new FilteringPrimitiveConverter(delegateConverter.asPrimitiveConverter(), valueInspectors);
        }
        return new FilteringGroupConverter(delegateConverter.asGroupConverter(), newIndexFieldPath, this.valueInspectorsByColumn, this.columnIOsByIndexFieldPath);
    }

    private PrimitiveColumnIO getColumnIO(List<Integer> indexFieldPath) {
        PrimitiveColumnIO found = this.columnIOsByIndexFieldPath.get(indexFieldPath);
        Preconditions.checkArgument(found != null, "Did not find PrimitiveColumnIO for index field path %s", indexFieldPath);
        return found;
    }

    private IncrementallyUpdatedFilterPredicate.ValueInspector[] getValueInspectors(ColumnPath columnPath) {
        List<IncrementallyUpdatedFilterPredicate.ValueInspector> inspectorsList = this.valueInspectorsByColumn.get(columnPath);
        return inspectorsList == null ? new IncrementallyUpdatedFilterPredicate.ValueInspector[]{} : inspectorsList.toArray(new IncrementallyUpdatedFilterPredicate.ValueInspector[0]);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void end() {
        this.delegate.end();
    }
}

