/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Comparator;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.JavaHash;
import org.apache.iceberg.types.Types;

public class StructLikeWrapper {
    private final Comparator<StructLike> comparator;
    private final JavaHash<StructLike> structHash;
    private Integer hashCode;
    private StructLike struct;

    public static StructLikeWrapper forType(Types.StructType type, Comparator<StructLike> comparator) {
        return new StructLikeWrapper(comparator, JavaHash.forType(type));
    }

    public static StructLikeWrapper forType(Types.StructType type) {
        return StructLikeWrapper.forType(type, Comparators.forType(type));
    }

    private StructLikeWrapper(Comparator<StructLike> comparator, JavaHash<StructLike> structHash) {
        this.comparator = comparator;
        this.structHash = structHash;
        this.hashCode = null;
    }

    public StructLikeWrapper copyFor(StructLike newStruct) {
        return new StructLikeWrapper(this.comparator, this.structHash).set(newStruct);
    }

    public StructLikeWrapper set(StructLike newStruct) {
        this.struct = newStruct;
        this.hashCode = null;
        return this;
    }

    public StructLike get() {
        return this.struct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructLikeWrapper)) {
            return false;
        }
        StructLikeWrapper that = (StructLikeWrapper)other;
        if (this.struct == that.struct) {
            return true;
        }
        if (this.struct == null ^ that.struct == null) {
            return false;
        }
        return this.comparator.compare(this.struct, that.struct) == 0;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.structHash.hash(this.struct);
        }
        return this.hashCode;
    }
}

