/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.type.AttributeToken;
import org.apache.atlas.type.ConstantToken;
import org.apache.atlas.type.Constants;
import org.apache.atlas.type.DependentToken;
import org.apache.atlas.type.TemplateToken;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityType.class);
    public static final AtlasEntityType ENTITY_ROOT = new AtlasRootEntityType();
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String OWNER = "owner";
    private static final String CREATE_TIME = "createTime";
    private static final String DYN_ATTRIBUTE_PREFIX = "dynAttribute:";
    private static final String OPTION_SCHEMA_ATTRIBUTES = "schemaAttributes";
    private static final String INTERNAL_TYPENAME = "__internal";
    public static final String OPTION_APPEND_RELATIONSHIPS_ON_PARTIAL_UPDATE = "appendRelationshipsOnPartialUpdate";
    private static final char NS_ATTRIBUTE_NAME_SEPARATOR = '.';
    private static final char DYN_ATTRIBUTE_NAME_SEPARATOR = '.';
    private static final char DYN_ATTRIBUTE_OPEN_DELIM = '{';
    private static final char DYN_ATTRIBUTE_CLOSE_DELIM = '}';
    private static final String[] ENTITY_HEADER_ATTRIBUTES = new String[]{"name", "description", "owner", "createTime"};
    private static final String ENTITY_ROOT_NAME = "__ENTITY_ROOT";
    private final AtlasEntityDef entityDef;
    private final String typeQryStr;
    private List<AtlasEntityType> superTypes = Collections.emptyList();
    private Set<String> allSuperTypes = Collections.emptySet();
    private Set<String> subTypes = Collections.emptySet();
    private Set<String> allSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSuperTypes = Collections.emptySet();
    private Map<String, Map<String, AtlasStructType.AtlasAttribute>> relationshipAttributes = Collections.emptyMap();
    private Map<String, Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>> businessAttributes = Collections.emptyMap();
    private List<AtlasStructType.AtlasAttribute> ownedRefAttributes = Collections.emptyList();
    private String displayTextAttribute = null;
    private String typeAndAllSubTypesQryStr = "";
    private boolean isInternalType = false;
    private Map<String, AtlasStructType.AtlasAttribute> headerAttributes = Collections.emptyMap();
    private Map<String, AtlasStructType.AtlasAttribute> minInfoAttributes = Collections.emptyMap();
    private List<AtlasStructType.AtlasAttribute> dynAttributes = Collections.emptyList();
    private List<AtlasStructType.AtlasAttribute> dynEvalTriggerAttributes = Collections.emptyList();
    private Map<String, List<TemplateToken>> parsedTemplates = Collections.emptyMap();
    private Set<String> tagPropagationEdges = Collections.emptySet();

    public AtlasEntityType(AtlasEntityDef entityDef) {
        super(entityDef);
        this.entityDef = entityDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()), true);
        this.displayTextAttribute = entityDef.getOption("displayTextAttribute");
    }

    public AtlasEntityType(AtlasEntityDef entityDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(entityDef);
        this.entityDef = entityDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()), true);
        this.displayTextAttribute = entityDef.getOption("displayTextAttribute");
        this.resolveReferences(typeRegistry);
    }

    public AtlasEntityDef getEntityDef() {
        return this.entityDef;
    }

    public static AtlasEntityType getEntityRoot() {
        return ENTITY_ROOT;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        List schemaAttributeNames;
        super.resolveReferences(typeRegistry);
        ArrayList<AtlasEntityType> s = new ArrayList<AtlasEntityType>();
        HashSet<String> allS = new HashSet<String>();
        HashMap<String, AtlasStructType.AtlasAttribute> allA = new HashMap<String, AtlasStructType.AtlasAttribute>();
        this.getTypeHierarchyInfo(typeRegistry, allS, allA);
        for (String superTypeName : this.entityDef.getSuperTypes()) {
            AtlasType superType = typeRegistry.getType(superTypeName);
            if (superType instanceof AtlasEntityType) {
                s.add((AtlasEntityType)superType);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.INCOMPATIBLE_SUPERTYPE, superTypeName, this.entityDef.getName());
        }
        this.superTypes = Collections.unmodifiableList(s);
        this.allSuperTypes = Collections.unmodifiableSet(allS);
        this.allAttributes = Collections.unmodifiableMap(allA);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
        this.subTypes = new HashSet<String>();
        this.allSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes = new HashSet<String>();
        this.relationshipAttributes = new HashMap<String, Map<String, AtlasStructType.AtlasAttribute>>();
        this.businessAttributes = new HashMap<String, Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>>();
        this.tagPropagationEdges = new HashSet<String>();
        this.typeAndAllSubTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = new HashSet<String>(this.allSuperTypes);
        this.typeAndAllSuperTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = Collections.unmodifiableSet(this.typeAndAllSuperTypes);
        this.headerAttributes = new HashMap<String, AtlasStructType.AtlasAttribute>(this.uniqAttributes);
        for (String headerAttributeName : ENTITY_HEADER_ATTRIBUTES) {
            AtlasStructType.AtlasAttribute headerAttribute = this.getAttribute(headerAttributeName);
            if (headerAttribute == null) continue;
            this.headerAttributes.put(headerAttributeName, headerAttribute);
        }
        this.minInfoAttributes = new HashMap<String, AtlasStructType.AtlasAttribute>(this.headerAttributes);
        Map<String, String> typeDefOptions = this.entityDef.getOptions();
        String jsonList = typeDefOptions != null ? typeDefOptions.get(OPTION_SCHEMA_ATTRIBUTES) : null;
        List list = schemaAttributeNames = StringUtils.isNotEmpty((String)jsonList) ? AtlasType.fromJson(jsonList, List.class) : null;
        if (CollectionUtils.isNotEmpty((Collection)schemaAttributeNames)) {
            for (String schemaAttributeName : schemaAttributeNames) {
                AtlasStructType.AtlasAttribute schemaAttribute = this.getAttribute(schemaAttributeName);
                if (schemaAttribute == null) continue;
                this.minInfoAttributes.put(schemaAttributeName, schemaAttribute);
            }
        }
        if (this.displayTextAttribute != null && this.getAttribute(this.displayTextAttribute) == null) {
            LOG.warn("{}: ignoring option {}, as attribute {} does not exist", new Object[]{this.getTypeName(), "displayTextAttribute", this.displayTextAttribute});
            this.displayTextAttribute = null;
        }
        if (this.displayTextAttribute == null) {
            for (AtlasEntityType superType : this.superTypes) {
                this.displayTextAttribute = superType.getEntityDef().getOption("displayTextAttribute");
                if (this.displayTextAttribute == null) continue;
                if (this.getAttribute(this.displayTextAttribute) != null) break;
                this.displayTextAttribute = null;
            }
        }
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasEntityType superType : this.superTypes) {
            superType.addSubType(this);
        }
        for (String superTypeName : this.allSuperTypes) {
            AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
            superType.addToAllSubTypes(this);
        }
    }

    @Override
    void resolveReferencesPhase3(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        for (AtlasStructDef.AtlasAttributeDef atlasAttributeDef : this.getStructDef().getAttributeDefs()) {
            String string = atlasAttributeDef.getName();
            AtlasType attributeType = typeRegistry.getType(atlasAttributeDef.getTypeName());
            AtlasEntityType attributeEntityType = AtlasEntityType.getReferencedEntityType(attributeType);
            if (attributeEntityType == null || this.hasRelationshipAttribute(string)) continue;
            typeRegistry.reportMissingRelationshipDef(this.getTypeName(), attributeEntityType.getTypeName(), string);
        }
        for (String string : this.allSuperTypes) {
            Object superTypeBusinessMetadata;
            AtlasEntityType atlasEntityType;
            Map<String, Map<String, AtlasStructType.AtlasAttribute>> superTypeRelationshipAttributes;
            if (INTERNAL_TYPENAME.equals(string)) {
                this.isInternalType = true;
            }
            if (MapUtils.isNotEmpty(superTypeRelationshipAttributes = (atlasEntityType = typeRegistry.getEntityTypeByName(string)).getRelationshipAttributes())) {
                for (String string2 : superTypeRelationshipAttributes.keySet()) {
                    Map<String, AtlasStructType.AtlasAttribute> superTypeAttributes = superTypeRelationshipAttributes.get(string2);
                    if (!MapUtils.isNotEmpty(superTypeAttributes)) continue;
                    Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(string2);
                    if (attributes == null) {
                        attributes = new HashMap<String, AtlasStructType.AtlasAttribute>();
                        this.relationshipAttributes.put(string2, attributes);
                    }
                    for (String relationshipType : superTypeAttributes.keySet()) {
                        if (attributes.containsKey(relationshipType)) continue;
                        attributes.put(relationshipType, superTypeAttributes.get(relationshipType));
                    }
                }
            }
            if (MapUtils.isNotEmpty(superTypeBusinessMetadata = atlasEntityType.getBusinessAttributes())) {
                for (Map.Entry<String, Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>> entry : superTypeBusinessMetadata.entrySet()) {
                    String bmName = entry.getKey();
                    Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> superTypeBmAttrs = entry.getValue();
                    Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> bmAttrs = this.businessAttributes.get(bmName);
                    if (bmAttrs == null) {
                        bmAttrs = new HashMap<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>();
                        this.businessAttributes.put(bmName, bmAttrs);
                    }
                    for (Map.Entry<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> bmAttrEntry : superTypeBmAttrs.entrySet()) {
                        bmAttrs.put(bmAttrEntry.getKey(), bmAttrEntry.getValue());
                    }
                }
            }
            this.tagPropagationEdges.addAll(atlasEntityType.tagPropagationEdges);
        }
        this.ownedRefAttributes = new ArrayList<AtlasStructType.AtlasAttribute>();
        for (AtlasStructType.AtlasAttribute atlasAttribute : this.allAttributes.values()) {
            if (!atlasAttribute.isOwnedRef()) continue;
            this.ownedRefAttributes.add(atlasAttribute);
        }
        for (Map map : this.relationshipAttributes.values()) {
            for (AtlasStructType.AtlasAttribute attribute : map.values()) {
                if (!attribute.isOwnedRef()) continue;
                this.ownedRefAttributes.add(attribute);
            }
        }
        this.subTypes = Collections.unmodifiableSet(this.subTypes);
        this.allSubTypes = Collections.unmodifiableSet(this.allSubTypes);
        this.typeAndAllSubTypes = Collections.unmodifiableSet(this.typeAndAllSubTypes);
        this.typeAndAllSubTypesQryStr = "";
        this.relationshipAttributes = Collections.unmodifiableMap(this.relationshipAttributes);
        this.businessAttributes = Collections.unmodifiableMap(this.businessAttributes);
        this.ownedRefAttributes = Collections.unmodifiableList(this.ownedRefAttributes);
        this.tagPropagationEdges = Collections.unmodifiableSet(this.tagPropagationEdges);
        this.entityDef.setSubTypes(this.subTypes);
        ArrayList<AtlasEntityDef.AtlasRelationshipAttributeDef> relationshipAttrDefs = new ArrayList<AtlasEntityDef.AtlasRelationshipAttributeDef>();
        for (Map.Entry<String, Map<String, AtlasStructType.AtlasAttribute>> entry : this.relationshipAttributes.entrySet()) {
            Map<String, AtlasStructType.AtlasAttribute> relations = entry.getValue();
            for (Map.Entry entry2 : relations.entrySet()) {
                String relationshipType = (String)entry2.getKey();
                AtlasStructType.AtlasAttribute relationshipAttr = (AtlasStructType.AtlasAttribute)entry2.getValue();
                AtlasEntityDef.AtlasRelationshipAttributeDef relationshipAttributeDef = new AtlasEntityDef.AtlasRelationshipAttributeDef(relationshipType, relationshipAttr.isLegacyAttribute(), relationshipAttr.getAttributeDef());
                this.updateRelationshipAttrDefForPartialUpdate(relationshipAttributeDef, this.entityDef);
                relationshipAttrDefs.add(relationshipAttributeDef);
            }
        }
        this.entityDef.setRelationshipAttributeDefs(Collections.unmodifiableList(relationshipAttrDefs));
        HashMap<String, List<AtlasStructDef.AtlasAttributeDef>> hashMap = new HashMap<String, List<AtlasStructDef.AtlasAttributeDef>>();
        for (Map.Entry<String, Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>> entry : this.businessAttributes.entrySet()) {
            String bmName = entry.getKey();
            Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> map = entry.getValue();
            ArrayList<AtlasStructDef.AtlasAttributeDef> bmAttrDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
            for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttr : map.values()) {
                bmAttrDefs.add(bmAttr.getAttributeDef());
            }
            hashMap.put(bmName, bmAttrDefs);
        }
        this.entityDef.setBusinessAttributeDefs(hashMap);
        if (this.displayTextAttribute == null) {
            for (String superTypeName : this.allSuperTypes) {
                AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
                this.displayTextAttribute = superType.getDisplayTextAttribute();
                if (this.displayTextAttribute == null) continue;
                break;
            }
        }
        this.parsedTemplates = this.parseDynAttributeTemplates();
        this.populateDynFlagsInfo();
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolveReferencesPhase3({}): tagPropagationEdges={}", (Object)this.getTypeName(), this.tagPropagationEdges);
        }
    }

    private void updateRelationshipAttrDefForPartialUpdate(AtlasEntityDef.AtlasRelationshipAttributeDef relationshipAttributeDef, AtlasEntityDef entityDef) {
        Set relationshipTypesToAppend;
        String appendRelationshipsOnPartialUpdate = entityDef.getOption(OPTION_APPEND_RELATIONSHIPS_ON_PARTIAL_UPDATE);
        String relationshipAttributeName = relationshipAttributeDef.getName();
        if (StringUtils.isNotEmpty((String)appendRelationshipsOnPartialUpdate) && CollectionUtils.isNotEmpty((Collection)(relationshipTypesToAppend = AtlasType.fromJson(appendRelationshipsOnPartialUpdate, Set.class))) && relationshipTypesToAppend.contains(relationshipAttributeName)) {
            relationshipAttributeDef.setOption("isAppendOnPartialUpdate", Boolean.toString(true));
        }
    }

    @Override
    public AtlasStructType.AtlasAttribute getSystemAttribute(String attributeName) {
        return (AtlasStructType.AtlasAttribute)AtlasEntityType.ENTITY_ROOT.allAttributes.get(attributeName);
    }

    @Override
    public AtlasBusinessMetadataType.AtlasBusinessAttribute getBusinesAAttribute(String bmAttrQualifiedName) {
        int idxSep;
        AtlasBusinessMetadataType.AtlasBusinessAttribute ret = null;
        if (bmAttrQualifiedName != null && (idxSep = bmAttrQualifiedName.indexOf(46)) != -1) {
            String bmName = bmAttrQualifiedName.substring(0, idxSep);
            String bmAttrName = bmAttrQualifiedName.substring(idxSep + 1);
            ret = this.getBusinessAttribute(bmName, bmAttrName);
        }
        return ret;
    }

    public Set<String> getSuperTypes() {
        return this.entityDef.getSuperTypes();
    }

    public Set<String> getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public Set<String> getSubTypes() {
        return this.subTypes;
    }

    public Set<String> getAllSubTypes() {
        return this.allSubTypes;
    }

    public Set<String> getTypeAndAllSubTypes() {
        return this.typeAndAllSubTypes;
    }

    public Set<String> getTypeAndAllSuperTypes() {
        return this.typeAndAllSuperTypes;
    }

    public Map<String, AtlasStructType.AtlasAttribute> getHeaderAttributes() {
        return this.headerAttributes;
    }

    public Map<String, AtlasStructType.AtlasAttribute> getMinInfoAttributes() {
        return this.minInfoAttributes;
    }

    public boolean isSuperTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSubTypes.contains(entityType.getTypeName());
    }

    public boolean isSuperTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSubTypes.contains(entityTypeName);
    }

    public boolean isTypeOrSuperTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.typeAndAllSubTypes.contains(entityTypeName);
    }

    public boolean isSubTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSuperTypes.contains(entityType.getTypeName());
    }

    public boolean isSubTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSuperTypes.contains(entityTypeName);
    }

    public boolean isInternalType() {
        return this.isInternalType;
    }

    public Map<String, Map<String, AtlasStructType.AtlasAttribute>> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public List<AtlasStructType.AtlasAttribute> getOwnedRefAttributes() {
        return this.ownedRefAttributes;
    }

    public String getDisplayTextAttribute() {
        return this.displayTextAttribute;
    }

    public List<AtlasStructType.AtlasAttribute> getDynEvalAttributes() {
        return this.dynAttributes;
    }

    @VisibleForTesting
    public void setDynEvalAttributes(List<AtlasStructType.AtlasAttribute> dynAttributes) {
        this.dynAttributes = dynAttributes;
    }

    public List<AtlasStructType.AtlasAttribute> getDynEvalTriggerAttributes() {
        return this.dynEvalTriggerAttributes;
    }

    @VisibleForTesting
    public void setDynEvalTriggerAttributes(List<AtlasStructType.AtlasAttribute> dynEvalTriggerAttributes) {
        this.dynEvalTriggerAttributes = dynEvalTriggerAttributes;
    }

    public Set<String> getTagPropagationEdges() {
        return this.tagPropagationEdges;
    }

    public String[] getTagPropagationEdgesArray() {
        return CollectionUtils.isNotEmpty(this.tagPropagationEdges) ? this.tagPropagationEdges.toArray(new String[this.tagPropagationEdges.size()]) : null;
    }

    public Map<String, List<TemplateToken>> getParsedTemplates() {
        return this.parsedTemplates;
    }

    public AtlasStructType.AtlasAttribute getRelationshipAttribute(String attributeName, String relationshipType) {
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        AtlasStructType.AtlasAttribute ret = MapUtils.isNotEmpty(attributes) ? (relationshipType != null && attributes.containsKey(relationshipType) ? attributes.get(relationshipType) : attributes.values().iterator().next()) : null;
        return ret;
    }

    void addRelationshipAttribute(String attributeName, AtlasStructType.AtlasAttribute attribute, AtlasRelationshipType relationshipType) {
        boolean propagatesTags;
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        if (attributes == null) {
            attributes = new HashMap<String, AtlasStructType.AtlasAttribute>();
            this.relationshipAttributes.put(attributeName, attributes);
        }
        attributes.put(relationshipType.getTypeName(), attribute);
        AtlasRelationshipDef.PropagateTags propagation = relationshipType.getRelationshipDef().getPropagateTags();
        if (propagation == null) {
            propagation = AtlasRelationshipDef.PropagateTags.NONE;
        }
        switch (propagation) {
            case BOTH: {
                propagatesTags = true;
                break;
            }
            case ONE_TO_TWO: {
                propagatesTags = StringUtils.equals((String)relationshipType.getEnd1Type().getTypeName(), (String)this.getTypeName());
                break;
            }
            case TWO_TO_ONE: {
                propagatesTags = StringUtils.equals((String)relationshipType.getEnd2Type().getTypeName(), (String)this.getTypeName());
                break;
            }
            default: {
                propagatesTags = false;
            }
        }
        if (propagatesTags) {
            this.tagPropagationEdges.add(relationshipType.getRelationshipLabel());
        }
    }

    public Set<String> getAttributeRelationshipTypes(String attributeName) {
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        return attributes != null ? attributes.keySet() : null;
    }

    public Map<String, Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>> getBusinessAttributes() {
        return this.businessAttributes;
    }

    public Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> getBusinessAttributes(String bmName) {
        return this.businessAttributes.get(bmName);
    }

    public AtlasBusinessMetadataType.AtlasBusinessAttribute getBusinessAttribute(String bmName, String bmAttrName) {
        Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> bmAttrs = this.businessAttributes.get(bmName);
        AtlasBusinessMetadataType.AtlasBusinessAttribute ret = bmAttrs != null ? bmAttrs.get(bmAttrName) : null;
        return ret;
    }

    public void addBusinessAttribute(AtlasBusinessMetadataType.AtlasBusinessAttribute attribute) {
        String bmName = attribute.getDefinedInType().getTypeName();
        Map<String, AtlasBusinessMetadataType.AtlasBusinessAttribute> bmAttrs = this.businessAttributes.get(bmName);
        if (bmAttrs == null) {
            bmAttrs = new HashMap<String, AtlasBusinessMetadataType.AtlasBusinessAttribute>();
            this.businessAttributes.put(bmName, bmAttrs);
        }
        bmAttrs.put(attribute.getName(), attribute);
    }

    public String getTypeAndAllSubTypesQryStr() {
        if (StringUtils.isEmpty((String)this.typeAndAllSubTypesQryStr)) {
            this.typeAndAllSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(this.typeAndAllSubTypes, true);
        }
        return this.typeAndAllSubTypesQryStr;
    }

    public String getTypeQryStr() {
        return this.typeQryStr;
    }

    public boolean hasAttribute(String attributeName) {
        return this.allAttributes.containsKey(attributeName);
    }

    public boolean hasRelationshipAttribute(String attributeName) {
        return this.relationshipAttributes.containsKey(attributeName);
    }

    @Override
    public String getVertexPropertyName(String attrName) throws AtlasBaseException {
        AtlasStructType.AtlasAttribute ret = this.getAttribute(attrName);
        if (ret == null) {
            ret = this.relationshipAttributes.get(attrName).values().iterator().next();
        }
        if (ret != null) {
            return ret.getVertexPropertyName();
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, attrName, this.entityDef.getName());
    }

    @Override
    public AtlasEntity createDefaultValue() {
        AtlasEntity ret = new AtlasEntity(this.entityDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public AtlasEntity createDefaultValue(Object defaultValue) {
        AtlasEntity ret = new AtlasEntity(this.entityDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValue(obj)) continue;
                return false;
            }
            return super.isValidValue(obj) && this.validateRelationshipAttributes(obj);
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        for (AtlasEntityType superType : this.superTypes) {
            if (superType.areEqualValues(val1, val2, guidAssignments)) continue;
            return false;
        }
        return super.areEqualValues(val1, val2, guidAssignments);
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValueForUpdate(obj)) continue;
                return false;
            }
            return super.isValidValueForUpdate(obj);
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValues((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValuesForUpdate((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValue(obj, objName, messages) && ret;
                }
                ret = super.validateValue(obj, objName, messages) && this.validateRelationshipAttributes(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValueForUpdate(obj, objName, messages) && ret;
                }
                ret = super.validateValueForUpdate(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasBuiltInTypes.AtlasObjectIdType attributeType = new AtlasBuiltInTypes.AtlasObjectIdType(this.getTypeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    public void normalizeAttributeValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(ent);
            }
            super.normalizeAttributeValues(ent);
            this.normalizeRelationshipAttributeValues(ent, false);
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(ent);
            }
            super.normalizeAttributeValuesForUpdate(ent);
            this.normalizeRelationshipAttributeValues(ent, true);
        }
    }

    @Override
    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(obj);
            }
            super.normalizeAttributeValues(obj);
            this.normalizeRelationshipAttributeValues(obj, false);
        }
    }

    @Override
    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(obj);
            }
            super.normalizeAttributeValuesForUpdate(obj);
            this.normalizeRelationshipAttributeValues(obj, true);
        }
    }

    public void populateDefaultValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.populateDefaultValues(ent);
            }
            super.populateDefaultValues(ent);
        }
    }

    private void addSubType(AtlasEntityType subType) {
        this.subTypes.add(subType.getTypeName());
    }

    private void addToAllSubTypes(AtlasEntityType subType) {
        this.allSubTypes.add(subType.getTypeName());
        this.typeAndAllSubTypes.add(subType.getTypeName());
    }

    private void getTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes) throws AtlasBaseException {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        HashMap<String, String> attributeToEntityNameMap = new HashMap<String, String>();
        this.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, attributeToEntityNameMap, visitedTypes);
    }

    private void collectTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes, Map<String, String> attributeToEntityNameMap, List<String> visitedTypes) throws AtlasBaseException {
        if (visitedTypes.contains(this.entityDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.CIRCULAR_REFERENCE, this.entityDef.getName(), visitedTypes.toString());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getSuperTypes())) {
            visitedTypes.add(this.entityDef.getName());
            for (String superTypeName : this.entityDef.getSuperTypes()) {
                AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
                if (superType == null) continue;
                superType.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, attributeToEntityNameMap, visitedTypes);
            }
            visitedTypes.remove(this.entityDef.getName());
            allSuperTypeNames.addAll(this.entityDef.getSuperTypes());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.entityDef.getAttributeDefs()) {
                AtlasType type = typeRegistry.getType(attributeDef.getTypeName());
                String attributeName = attributeDef.getName();
                if (attributeToEntityNameMap.containsKey(attributeName) && !attributeToEntityNameMap.get(attributeName).equals(this.entityDef.getName())) {
                    if (skipCheckForParentChildAttributeName) {
                        LOG.warn(AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getFormattedErrorMessage(this.entityDef.getName(), attributeName, attributeToEntityNameMap.get(attributeName)));
                    } else {
                        throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE, this.entityDef.getName(), attributeName, attributeToEntityNameMap.get(attributeName));
                    }
                }
                allAttributes.put(attributeName, new AtlasStructType.AtlasAttribute(this, attributeDef, type));
                attributeToEntityNameMap.put(attributeName, this.entityDef.getName());
            }
        }
    }

    private void populateDynFlagsInfo() {
        this.dynAttributes = new ArrayList<AtlasStructType.AtlasAttribute>();
        this.dynEvalTriggerAttributes = new ArrayList<AtlasStructType.AtlasAttribute>();
        for (String string : this.parsedTemplates.keySet()) {
            AtlasStructType.AtlasAttribute attribute = this.getAttribute(string);
            if (attribute == null) continue;
            this.dynAttributes.add(attribute);
        }
        this.dynAttributes = this.reorderDynAttributes();
        for (List list : this.parsedTemplates.values()) {
            for (TemplateToken token : list) {
                AtlasStructType.AtlasAttribute attribute;
                if (!(token instanceof AttributeToken) || (attribute = this.getAttribute(token.getValue())) == null) continue;
                this.dynEvalTriggerAttributes.add(attribute);
            }
        }
        this.dynAttributes = Collections.unmodifiableList(this.dynAttributes);
        this.dynEvalTriggerAttributes = Collections.unmodifiableList(this.dynEvalTriggerAttributes);
        for (AtlasStructType.AtlasAttribute atlasAttribute : this.dynAttributes) {
            atlasAttribute.setIsDynAttribute(true);
        }
        for (AtlasStructType.AtlasAttribute atlasAttribute : this.dynEvalTriggerAttributes) {
            atlasAttribute.setIsDynAttributeEvalTrigger(true);
        }
    }

    private Map<String, List<TemplateToken>> parseDynAttributeTemplates() {
        HashMap<String, List<TemplateToken>> ret = new HashMap<String, List<TemplateToken>>();
        Map<String, String> options = this.entityDef.getOptions();
        if (options == null || options.size() == 0) {
            return ret;
        }
        for (String key : options.keySet()) {
            if (!key.startsWith(DYN_ATTRIBUTE_PREFIX)) continue;
            String attributeName = key.substring(DYN_ATTRIBUTE_PREFIX.length());
            AtlasStructType.AtlasAttribute attribute = this.getAttribute(attributeName);
            if (attribute == null) {
                LOG.warn("Ignoring {} attribute of {} type as dynamic attribute because attribute does not exist", (Object)attributeName, (Object)this.getTypeName());
                continue;
            }
            if (!(attribute.getAttributeType() instanceof AtlasBuiltInTypes.AtlasStringType)) {
                LOG.warn("Ignoring {} attribute of {} type as dynamic attribute because attribute isn't a string type", (Object)attributeName, (Object)this.getTypeName());
                continue;
            }
            String template = options.get(key);
            List<TemplateToken> splitTemplate = this.templateSplit(template);
            ret.put(attributeName, splitTemplate);
        }
        return Collections.unmodifiableMap(ret);
    }

    private List<TemplateToken> templateSplit(String template) {
        ArrayList<TemplateToken> ret = new ArrayList<TemplateToken>();
        StringBuilder token = new StringBuilder();
        boolean isInAttrName = false;
        block4: for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (c) {
                case '{': {
                    isInAttrName = true;
                    if (token.length() <= 0) continue block4;
                    ret.add(new ConstantToken(token.toString()));
                    token.setLength(0);
                    continue block4;
                }
                case '}': {
                    if (isInAttrName) {
                        isInAttrName = false;
                        if (token.length() <= 0) continue block4;
                        String attrName = token.toString();
                        if (attrName.indexOf(46) != -1) {
                            ret.add(new DependentToken(token.toString()));
                        } else {
                            ret.add(new AttributeToken(token.toString()));
                        }
                        token.setLength(0);
                        continue block4;
                    }
                    token.append(c);
                    continue block4;
                }
                default: {
                    token.append(c);
                }
            }
        }
        return ret;
    }

    boolean isAssignableFrom(AtlasObjectId objId) {
        boolean ret = AtlasTypeUtil.isValid(objId) && (StringUtils.equals((String)objId.getTypeName(), (String)this.getTypeName()) || this.isSuperTypeOf(objId.getTypeName()));
        return ret;
    }

    private boolean validateRelationshipAttributes(Object obj) {
        if (obj != null && MapUtils.isNotEmpty(this.relationshipAttributes)) {
            if (obj instanceof AtlasEntity) {
                AtlasEntity entityObj = (AtlasEntity)obj;
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute;
                    AtlasStructDef.AtlasAttributeDef attributeDef;
                    Object attributeValue = entityObj.getRelationshipAttribute(attributeName);
                    if (this.isAssignableValue(attributeValue, attributeDef = (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue))).getAttributeDef())) continue;
                    return false;
                }
            } else if (obj instanceof Map) {
                Map map = AtlasTypeUtil.toRelationshipAttributes((Map)obj);
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute;
                    AtlasStructDef.AtlasAttributeDef attributeDef;
                    Object attributeValue = map.get(attributeName);
                    if (this.isAssignableValue(attributeValue, attributeDef = (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue))).getAttributeDef())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static Set<String> getEntityTypesAndAllSubTypes(Set<String> entityTypes, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        HashSet<String> ret = new HashSet<String>();
        for (String typeName : entityTypes) {
            AtlasEntityType entityType = typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, typeName);
            }
            ret.addAll(entityType.getTypeAndAllSubTypes());
        }
        return ret;
    }

    private boolean isAssignableValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        boolean ret = true;
        if (value != null) {
            AtlasType attrType;
            String relationshipType = AtlasEntityUtil.getRelationshipType(value);
            AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeDef.getName(), relationshipType);
            if (attribute != null && !this.isValidRelationshipType(attrType = attribute.getAttributeType()) && !attrType.isValidValue(value)) {
                ret = false;
            }
        }
        return ret;
    }

    private boolean isValidRelationshipType(AtlasType attributeType) {
        boolean ret = false;
        if (attributeType != null) {
            if (attributeType instanceof AtlasArrayType) {
                attributeType = ((AtlasArrayType)attributeType).getElementType();
            }
            if (attributeType instanceof AtlasBuiltInTypes.AtlasObjectIdType || attributeType instanceof AtlasEntityType) {
                ret = true;
            }
        }
        return ret;
    }

    private void normalizeRelationshipAttributeValues(AtlasEntity entity, boolean isUpdate) {
        if (entity != null) {
            for (String attributeName : this.relationshipAttributes.keySet()) {
                AtlasType attrType;
                Object attributeValue;
                String relationshipType;
                AtlasStructType.AtlasAttribute attribute;
                if (!entity.hasRelationshipAttribute(attributeName) || (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue = entity.getRelationshipAttribute(attributeName)))) == null || !this.isValidRelationshipType(attrType = attribute.getAttributeType())) continue;
                attributeValue = isUpdate ? attrType.getNormalizedValueForUpdate(attributeValue) : attrType.getNormalizedValue(attributeValue);
                entity.setRelationshipAttribute(attributeName, attributeValue);
            }
        }
    }

    public void normalizeRelationshipAttributeValues(Map<String, Object> obj, boolean isUpdate) {
        if (obj != null) {
            for (String attributeName : this.relationshipAttributes.keySet()) {
                AtlasType attrType;
                Object attributeValue;
                String relationshipType;
                AtlasStructType.AtlasAttribute attribute;
                if (!obj.containsKey(attributeName) || (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue = obj.get(attributeName)))) == null || !this.isValidRelationshipType(attrType = attribute.getAttributeType())) continue;
                attributeValue = isUpdate ? attrType.getNormalizedValueForUpdate(attributeValue) : attrType.getNormalizedValue(attributeValue);
                obj.put(attributeName, attributeValue);
            }
        }
    }

    private boolean validateRelationshipAttributes(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null && MapUtils.isNotEmpty(this.relationshipAttributes)) {
            if (obj instanceof AtlasEntity) {
                AtlasEntity entityObj = (AtlasEntity)obj;
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    Object value;
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(value = entityObj.getRelationshipAttribute(attributeName)));
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    if (!attribute.getAttributeDef().getIsOptional()) {
                        if (value == null) {
                            value = entityObj.getRelationshipAttribute(attributeName);
                        }
                        if (value == null) {
                            if (entityObj.getIsIncomplete() != null && entityObj.getIsIncomplete().booleanValue()) continue;
                            ret = false;
                            messages.add(objName + "." + attributeName + ": mandatory attribute value missing in type " + this.getTypeName());
                        }
                    }
                    if (!this.isValidRelationshipType(dataType) || value == null) continue;
                    ret = dataType.validateValue(value, objName + "." + attributeName, messages) && ret;
                }
            } else if (obj instanceof Map) {
                Map attributes = AtlasTypeUtil.toRelationshipAttributes((Map)obj);
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    AtlasType dataType;
                    Object value;
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(value = attributes.get(attributeName)));
                    if (attribute == null || !this.isValidRelationshipType(dataType = attribute.getAttributeType()) || value == null) continue;
                    ret = dataType.validateValue(value, objName + "." + attributeName, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    private List<AtlasStructType.AtlasAttribute> reorderDynAttributes() {
        Map<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>> adj = this.createTokenAttributesMap();
        return this.topologicalSort(adj);
    }

    private List<AtlasStructType.AtlasAttribute> topologicalSort(Map<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>> adj) {
        ArrayList<AtlasStructType.AtlasAttribute> order = new ArrayList<AtlasStructType.AtlasAttribute>();
        HashSet<AtlasStructType.AtlasAttribute> visited = new HashSet<AtlasStructType.AtlasAttribute>();
        for (AtlasStructType.AtlasAttribute attribute : adj.keySet()) {
            this.visitAttribute(attribute, visited, order, adj);
        }
        Collections.reverse(order);
        return order;
    }

    private void visitAttribute(AtlasStructType.AtlasAttribute attribute, Set<AtlasStructType.AtlasAttribute> visited, List<AtlasStructType.AtlasAttribute> order, Map<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>> adj) {
        if (!visited.contains(attribute)) {
            visited.add(attribute);
            for (AtlasStructType.AtlasAttribute neighbor : adj.get(attribute)) {
                this.visitAttribute(neighbor, visited, order, adj);
            }
            order.add(attribute);
        }
    }

    private Map<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>> createTokenAttributesMap() {
        HashMap<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>> adj = new HashMap<AtlasStructType.AtlasAttribute, List<AtlasStructType.AtlasAttribute>>();
        for (AtlasStructType.AtlasAttribute attribute : this.dynAttributes) {
            adj.put(attribute, new ArrayList());
        }
        for (AtlasStructType.AtlasAttribute attribute : adj.keySet()) {
            for (TemplateToken token : this.parsedTemplates.get(attribute.getName())) {
                AtlasStructType.AtlasAttribute tokenAttribute;
                if (!(token instanceof AttributeToken) || !adj.containsKey(tokenAttribute = this.getAttribute(token.getValue()))) continue;
                ((List)adj.get(tokenAttribute)).add(attribute);
            }
        }
        return adj;
    }

    private static class AtlasRootEntityType
    extends AtlasEntityType {
        private AtlasTypeRegistry typeRegistry = null;

        public AtlasRootEntityType() {
            super(AtlasRootEntityType.getRootEntityDef());
        }

        @Override
        void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
            super.resolveReferences(typeRegistry);
            this.typeRegistry = typeRegistry;
        }

        @Override
        public AtlasBusinessMetadataType.AtlasBusinessAttribute getBusinessAttribute(String bmName, String bmAttrName) {
            AtlasBusinessMetadataType bmType = this.typeRegistry != null ? this.typeRegistry.getBusinessMetadataTypeByName(bmName) : null;
            AtlasStructType.AtlasAttribute bmAttr = bmType != null ? bmType.getAttribute(bmAttrName) : null;
            return bmAttr instanceof AtlasBusinessMetadataType.AtlasBusinessAttribute ? (AtlasBusinessMetadataType.AtlasBusinessAttribute)bmAttr : null;
        }

        private static AtlasEntityDef getRootEntityDef() {
            ArrayList<AtlasStructDef.AtlasAttributeDef> attributeDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>(){
                {
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.TIMESTAMP_PROPERTY_KEY, "date", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, "date", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.MODIFIED_BY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.CREATED_BY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.STATE_PROPERTY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.GUID_PROPERTY_KEY, "string", true, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.HISTORICAL_GUID_PROPERTY_KEY, "string", true, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.TYPE_NAME_PROPERTY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.CLASSIFICATION_TEXT_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.CLASSIFICATION_NAMES_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.IS_INCOMPLETE_PROPERTY_KEY, "int", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.LABELS_PROPERTY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY, "string", false, true));
                    this.add(new AtlasStructDef.AtlasAttributeDef(Constants.PENDING_TASKS_PROPERTY_KEY, "string", false, true));
                }
            };
            return new AtlasEntityDef(AtlasEntityType.ENTITY_ROOT_NAME, "Root entity for system attributes", "1.0", (List<AtlasStructDef.AtlasAttributeDef>)attributeDefs);
        }
    }
}

