/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTrace {
    private static final Logger log = LoggerFactory.getLogger(DistributedTrace.class);
    private static final String HTRACE_CONF_PREFIX = "hadoop.";
    public static final String TRACE_HOST_PROPERTY = "trace.host";
    public static final String TRACE_SERVICE_PROPERTY = "trace.service";
    public static final String TRACER_ZK_HOST = "tracer.zookeeper.host";
    public static final String TRACER_ZK_TIMEOUT = "tracer.zookeeper.timeout";
    public static final String TRACER_ZK_PATH = "tracer.zookeeper.path";
    private static final HashSet<SpanReceiver> receivers = new HashSet();

    @Deprecated
    public static void enable(Instance instance, ZooReader zoo, String application, String address) throws IOException, KeeperException, InterruptedException {
        DistributedTrace.enable(address, application);
    }

    public static void enable() {
        DistributedTrace.enable(null, null);
    }

    public static void enable(String service) {
        DistributedTrace.enable(null, service);
    }

    public static void enable(String hostname, String service) {
        DistributedTrace.enable(hostname, service, ClientConfiguration.loadDefault());
    }

    public static void enable(String hostname, String service, ClientConfiguration conf) {
        String spanReceivers = conf.get(ClientConfiguration.ClientProperty.TRACE_SPAN_RECEIVERS);
        String zookeepers = conf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        long timeout = AccumuloConfiguration.getTimeInMillis(conf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT));
        String zkPath = conf.get(ClientConfiguration.ClientProperty.TRACE_ZK_PATH);
        Map<String, String> properties = conf.getAllPropertiesWithPrefix(ClientConfiguration.ClientProperty.TRACE_SPAN_RECEIVER_PREFIX);
        DistributedTrace.enableTracing(hostname, service, spanReceivers, zookeepers, timeout, zkPath, properties);
    }

    public static void enable(String hostname, String service, AccumuloConfiguration conf) {
        String spanReceivers = conf.get(Property.TRACE_SPAN_RECEIVERS);
        String zookeepers = conf.get(Property.INSTANCE_ZK_HOST);
        long timeout = conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
        String zkPath = conf.get(Property.TRACE_ZK_PATH);
        Map<String, String> properties = conf.getAllPropertiesWithPrefix(Property.TRACE_SPAN_RECEIVER_PREFIX);
        DistributedTrace.enableTracing(hostname, service, spanReceivers, zookeepers, timeout, zkPath, properties);
    }

    private static void enableTracing(String hostname, String service, String spanReceivers, String zookeepers, long timeout, String zkPath, Map<String, String> properties) {
        Configuration conf = new Configuration(false);
        conf.set(Property.TRACE_SPAN_RECEIVERS.toString(), spanReceivers);
        DistributedTrace.setProperty(conf, TRACER_ZK_HOST, zookeepers);
        DistributedTrace.setProperty(conf, TRACER_ZK_TIMEOUT, (int)timeout);
        DistributedTrace.setProperty(conf, TRACER_ZK_PATH, zkPath);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            DistributedTrace.setProperty(conf, property.getKey().substring(Property.TRACE_SPAN_RECEIVER_PREFIX.getKey().length()), property.getValue());
        }
        if (hostname != null) {
            DistributedTrace.setProperty(conf, TRACE_HOST_PROPERTY, hostname);
        }
        if (service != null) {
            DistributedTrace.setProperty(conf, TRACE_SERVICE_PROPERTY, service);
        }
        org.apache.htrace.Trace.setProcessId((String)service);
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                Trace.off();
                DistributedTrace.closeReceivers();
            }
        }, 0);
        DistributedTrace.loadSpanReceivers(conf);
    }

    public static void disable() {
        DistributedTrace.closeReceivers();
    }

    private static synchronized void loadSpanReceivers(Configuration conf) {
        if (!receivers.isEmpty()) {
            log.info("Already loaded span receivers, enable tracing does not need to be called again");
            return;
        }
        String[] receiverNames = conf.getTrimmedStrings(Property.TRACE_SPAN_RECEIVERS.toString());
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        for (String className : receiverNames) {
            SpanReceiverBuilder builder = new SpanReceiverBuilder(DistributedTrace.wrapHadoopConf(conf));
            SpanReceiver rcvr = builder.spanReceiverClass(className.trim()).build();
            if (rcvr == null) {
                log.warn("Failed to load SpanReceiver " + className);
                continue;
            }
            receivers.add(rcvr);
            log.info("SpanReceiver " + className + " was loaded successfully.");
        }
        for (SpanReceiver rcvr : receivers) {
            org.apache.htrace.Trace.addReceiver((SpanReceiver)rcvr);
        }
    }

    private static void setProperty(Configuration conf, String key, String value) {
        conf.set(HTRACE_CONF_PREFIX + key, value);
    }

    private static void setProperty(Configuration conf, String key, int value) {
        conf.setInt(HTRACE_CONF_PREFIX + key, value);
    }

    private static HTraceConfiguration wrapHadoopConf(final Configuration conf) {
        return new HTraceConfiguration(){

            public String get(String key) {
                return conf.get(DistributedTrace.HTRACE_CONF_PREFIX + key);
            }

            public String get(String key, String defaultValue) {
                return conf.get(DistributedTrace.HTRACE_CONF_PREFIX + key, defaultValue);
            }
        };
    }

    private static synchronized void closeReceivers() {
        for (SpanReceiver rcvr : receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                log.warn("Unable to close SpanReceiver correctly: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        receivers.clear();
    }
}

