/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.lexicoder.impl.AbstractLexicoder;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.TypedValueCombiner;
import org.apache.accumulo.core.iterators.ValueFormatException;
import org.apache.hadoop.io.WritableUtils;

public abstract class LongCombiner
extends TypedValueCombiner<Long> {
    public static final TypedValueCombiner.Encoder<Long> FIXED_LEN_ENCODER = new FixedLenEncoder();
    public static final TypedValueCombiner.Encoder<Long> VAR_LEN_ENCODER = new VarLenEncoder();
    public static final TypedValueCombiner.Encoder<Long> STRING_ENCODER = new StringEncoder();
    protected static final String TYPE = "type";
    protected static final String CLASS_PREFIX = "class:";

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.setEncoder(options);
    }

    private void setEncoder(Map<String, String> options) {
        String type = options.get(TYPE);
        if (type == null) {
            throw new IllegalArgumentException("no type specified");
        }
        if (!type.startsWith(CLASS_PREFIX)) {
            switch (Type.valueOf(type)) {
                case VARLEN: {
                    this.setEncoder(VAR_LEN_ENCODER);
                    return;
                }
                case FIXEDLEN: {
                    this.setEncoder(FIXED_LEN_ENCODER);
                    return;
                }
                case STRING: {
                    this.setEncoder(STRING_ENCODER);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }
        this.setEncoder(type.substring(CLASS_PREFIX.length()));
        this.testEncoder(42L);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("longcombiner");
        io.setDescription("LongCombiner can interpret Values as Longs in a variety of encodings (variable length, fixed length, or string) before combining");
        io.addNamedOption(TYPE, "<VARLEN|FIXEDLEN|STRING|fullClassName>");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            this.setEncoder(options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad encoder option", e);
        }
        return true;
    }

    public static long safeAdd(long a, long b) {
        long aSign = Long.signum(a);
        long bSign = Long.signum(b);
        if (aSign != 0L && bSign != 0L && aSign == bSign) {
            if (aSign > 0L) {
                if (Long.MAX_VALUE - a < b) {
                    return Long.MAX_VALUE;
                }
            } else if (Long.MIN_VALUE - a > b) {
                return Long.MIN_VALUE;
            }
        }
        return a + b;
    }

    public static void setEncodingType(IteratorSetting is, Type type) {
        is.addOption(TYPE, type.toString());
    }

    public static void setEncodingType(IteratorSetting is, Class<? extends TypedValueCombiner.Encoder<Long>> encoderClass) {
        is.addOption(TYPE, CLASS_PREFIX + encoderClass.getName());
    }

    public static void setEncodingType(IteratorSetting is, String encoderClassName) {
        is.addOption(TYPE, CLASS_PREFIX + encoderClassName);
    }

    public static class StringEncoder
    extends AbstractLexicoder<Long> {
        @Override
        public byte[] encode(Long v) {
            return Long.toString(v).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public Long decode(byte[] b) {
            return (Long)super.decode(b);
        }

        @Override
        protected Long decodeUnchecked(byte[] b, int offset, int len) {
            try {
                return Long.parseLong(new String(b, offset, len, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                throw new ValueFormatException(nfe);
            }
        }
    }

    public static class FixedLenEncoder
    extends AbstractLexicoder<Long> {
        @Override
        public byte[] encode(Long l) {
            byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
            return b;
        }

        @Override
        public Long decode(byte[] b) {
            return (Long)super.decode(b);
        }

        @Override
        protected Long decodeUnchecked(byte[] b, int offset, int len) {
            return FixedLenEncoder.decodeStatic(b, offset, len);
        }

        public static long decode(byte[] b, int offset) {
            if (b.length < offset + 8) {
                throw new ValueFormatException("trying to convert to long, but byte array isn't long enough, wanted " + (offset + 8) + " found " + b.length);
            }
            return ((long)b[offset + 0] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
        }

        public static long decodeStatic(byte[] b, int offset, int len) {
            if (b.length < offset + 8 || len < 8) {
                throw new ValueFormatException("trying to convert to long, but byte array isn't long enough, wanted " + (offset + 8) + " found " + len);
            }
            return ((long)b[offset + 0] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
        }
    }

    public static class VarLenEncoder
    extends AbstractLexicoder<Long> {
        @Override
        public byte[] encode(Long v) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                WritableUtils.writeVLong((DataOutput)dos, (long)v);
            }
            catch (IOException e) {
                throw new NumberFormatException(e.getMessage());
            }
            return baos.toByteArray();
        }

        @Override
        public Long decode(byte[] b) {
            return (Long)super.decode(b);
        }

        @Override
        protected Long decodeUnchecked(byte[] b, int offset, int len) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b, offset, len));
            try {
                return WritableUtils.readVLong((DataInput)dis);
            }
            catch (IOException e) {
                throw new ValueFormatException(e);
            }
        }
    }

    public static enum Type {
        VARLEN,
        FIXEDLEN,
        STRING;

    }
}

