/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.accumulo.core.file.streams.PositionedOutput;
import org.apache.accumulo.core.file.streams.PositionedOutputs;
import org.apache.accumulo.core.util.ratelimit.NullRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;

public class RateLimitedOutputStream
extends FilterOutputStream
implements PositionedOutput {
    private final RateLimiter writeLimiter;

    public RateLimitedOutputStream(OutputStream wrappedStream, RateLimiter writeLimiter) {
        super(PositionedOutputs.wrap(wrappedStream));
        this.writeLimiter = writeLimiter == null ? NullRateLimiter.INSTANCE : writeLimiter;
    }

    @Override
    public void write(int i) throws IOException {
        this.writeLimiter.acquire(1L);
        this.out.write(i);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.writeLimiter.acquire(length);
        this.out.write(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public long position() throws IOException {
        return ((PositionedOutput)((Object)this.out)).position();
    }
}

