/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.sample;

import com.google.common.collect.ImmutableSet;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.accumulo.core.client.sample.AbstractHashSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;

public class RowColumnSampler
extends AbstractHashSampler {
    private boolean row = true;
    private boolean family = true;
    private boolean qualifier = true;
    private boolean visibility = true;
    private static final Set<String> VALID_OPTIONS = ImmutableSet.of((Object)"row", (Object)"family", (Object)"qualifier", (Object)"visibility");

    private boolean hashField(SamplerConfiguration config, String field) {
        String optValue = config.getOptions().get(field);
        if (optValue != null) {
            return Boolean.parseBoolean(optValue);
        }
        return false;
    }

    @Override
    protected boolean isValidOption(String option) {
        return super.isValidOption(option) || VALID_OPTIONS.contains(option);
    }

    @Override
    public void init(SamplerConfiguration config) {
        super.init(config);
        this.row = this.hashField(config, "row");
        this.family = this.hashField(config, "family");
        this.qualifier = this.hashField(config, "qualifier");
        this.visibility = this.hashField(config, "visibility");
        if (!(this.row || this.family || this.qualifier || this.visibility)) {
            throw new IllegalStateException("Must hash at least one key field");
        }
    }

    private void putByteSquence(ByteSequence data, DataOutput hasher) throws IOException {
        hasher.write(data.getBackingArray(), data.offset(), data.length());
    }

    @Override
    protected void hash(DataOutput hasher, Key k) throws IOException {
        if (this.row) {
            this.putByteSquence(k.getRowData(), hasher);
        }
        if (this.family) {
            this.putByteSquence(k.getColumnFamilyData(), hasher);
        }
        if (this.qualifier) {
            this.putByteSquence(k.getColumnQualifierData(), hasher);
        }
        if (this.visibility) {
            this.putByteSquence(k.getColumnVisibilityData(), hasher);
        }
    }
}

