/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.EnumSet;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.client.mock.MockNamespace;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.client.mock.MockUser;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;

@Deprecated
class MockSecurityOperations
implements SecurityOperations {
    private final MockAccumulo acu;

    MockSecurityOperations(MockAccumulo acu) {
        this.acu = acu;
    }

    @Override
    @Deprecated
    public void createUser(String user, byte[] password, Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        this.createLocalUser(user, new PasswordToken(password));
        this.changeUserAuthorizations(user, authorizations);
    }

    @Override
    public void createLocalUser(String principal, PasswordToken password) throws AccumuloException, AccumuloSecurityException {
        this.acu.users.put(principal, new MockUser(principal, password, new Authorizations()));
    }

    @Override
    @Deprecated
    public void dropUser(String user) throws AccumuloException, AccumuloSecurityException {
        this.dropLocalUser(user);
    }

    @Override
    public void dropLocalUser(String principal) throws AccumuloException, AccumuloSecurityException {
        this.acu.users.remove(principal);
    }

    @Override
    @Deprecated
    public boolean authenticateUser(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        return this.authenticateUser(user, new PasswordToken(password));
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user == null) {
            return false;
        }
        return user.token.equals(token);
    }

    @Override
    @Deprecated
    public void changeUserPassword(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        this.changeLocalUserPassword(user, new PasswordToken(password));
    }

    @Override
    public void changeLocalUserPassword(String principal, PasswordToken token) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        user.token = token.clone();
    }

    @Override
    public void changeUserAuthorizations(String principal, Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        user.authorizations = authorizations;
    }

    @Override
    public Authorizations getUserAuthorizations(String principal) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user != null) {
            return user.authorizations;
        }
        throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
    }

    @Override
    public boolean hasSystemPermission(String principal, SystemPermission perm) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user != null) {
            return user.permissions.contains((Object)perm);
        }
        throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
    }

    @Override
    public boolean hasTablePermission(String principal, String tableName, TablePermission perm) throws AccumuloException, AccumuloSecurityException {
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new AccumuloSecurityException(tableName, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
        EnumSet<TablePermission> perms = table.userPermissions.get(principal);
        if (perms == null) {
            return false;
        }
        return perms.contains((Object)perm);
    }

    @Override
    public boolean hasNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        MockNamespace mockNamespace = this.acu.namespaces.get(namespace);
        if (mockNamespace == null) {
            throw new AccumuloSecurityException(namespace, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
        EnumSet<NamespacePermission> perms = mockNamespace.userPermissions.get(principal);
        if (perms == null) {
            return false;
        }
        return perms.contains((Object)permission);
    }

    @Override
    public void grantSystemPermission(String principal, SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        user.permissions.add(permission);
    }

    @Override
    public void grantTablePermission(String principal, String tableName, TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        if (this.acu.users.get(principal) == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new AccumuloSecurityException(tableName, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
        EnumSet<TablePermission> perms = table.userPermissions.get(principal);
        if (perms == null) {
            table.userPermissions.put(principal, EnumSet.of(permission));
        } else {
            perms.add(permission);
        }
    }

    @Override
    public void grantNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        if (this.acu.users.get(principal) == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        MockNamespace mockNamespace = this.acu.namespaces.get(namespace);
        if (mockNamespace == null) {
            throw new AccumuloSecurityException(namespace, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
        EnumSet<NamespacePermission> perms = mockNamespace.userPermissions.get(principal);
        if (perms == null) {
            mockNamespace.userPermissions.put(principal, EnumSet.of(permission));
        } else {
            perms.add(permission);
        }
    }

    @Override
    public void revokeSystemPermission(String principal, SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        MockUser user = this.acu.users.get(principal);
        if (user == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        user.permissions.remove((Object)permission);
    }

    @Override
    public void revokeTablePermission(String principal, String tableName, TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        if (this.acu.users.get(principal) == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new AccumuloSecurityException(tableName, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
        EnumSet<TablePermission> perms = table.userPermissions.get(principal);
        if (perms != null) {
            perms.remove((Object)permission);
        }
    }

    @Override
    public void revokeNamespacePermission(String principal, String namespace, NamespacePermission permission) throws AccumuloException, AccumuloSecurityException {
        if (this.acu.users.get(principal) == null) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
        MockNamespace mockNamespace = this.acu.namespaces.get(namespace);
        if (mockNamespace == null) {
            throw new AccumuloSecurityException(namespace, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
        EnumSet<NamespacePermission> perms = mockNamespace.userPermissions.get(principal);
        if (perms != null) {
            perms.remove((Object)permission);
        }
    }

    @Override
    @Deprecated
    public Set<String> listUsers() throws AccumuloException, AccumuloSecurityException {
        return this.listLocalUsers();
    }

    @Override
    public Set<String> listLocalUsers() throws AccumuloException, AccumuloSecurityException {
        return this.acu.users.keySet();
    }

    @Override
    public DelegationToken getDelegationToken(DelegationTokenConfig cfg) throws AccumuloException, AccumuloSecurityException {
        return null;
    }
}

