/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ThriftTransportKey;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTransportPool {
    private static SecurityPermission TRANSPORT_POOL_PERMISSION = new SecurityPermission("transportPoolPermission");
    private static final Random random = new Random();
    private long killTime = 3000L;
    private Map<ThriftTransportKey, CachedConnections> cache = new HashMap<ThriftTransportKey, CachedConnections>();
    private Map<ThriftTransportKey, Long> errorCount = new HashMap<ThriftTransportKey, Long>();
    private Map<ThriftTransportKey, Long> errorTime = new HashMap<ThriftTransportKey, Long>();
    private Set<ThriftTransportKey> serversWarnedAbout = new HashSet<ThriftTransportKey>();
    private CountDownLatch closerExitLatch;
    private static final Logger log = LoggerFactory.getLogger(ThriftTransportPool.class);
    private static final Long ERROR_THRESHOLD = 20L;
    private static final int STUCK_THRESHOLD = 120000;
    private static ThriftTransportPool instance = new ThriftTransportPool();
    private static final AtomicBoolean daemonStarted = new AtomicBoolean(false);

    private ThriftTransportPool() {
    }

    public TTransport getTransport(HostAndPort location, long milliseconds, ClientContext context) throws TTransportException {
        return this.getTransport(new ThriftTransportKey(location, milliseconds, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport getTransport(ThriftTransportKey cacheKey) throws TTransportException {
        cacheKey.precomputeHashCode();
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            CachedConnection cachedConnection;
            CachedConnections ccl = this.getCache().get(cacheKey);
            if (ccl == null) {
                ccl = new CachedConnections();
                this.getCache().put(cacheKey, ccl);
            }
            if ((cachedConnection = ccl.reserveAny()) != null) {
                log.trace("Using existing connection to {}", (Object)cacheKey.getServer());
                return cachedConnection.transport;
            }
        }
        return this.createNewTransport(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Pair<String, TTransport> getAnyTransport(List<ThriftTransportKey> servers, boolean preferCachedConnection) throws TTransportException {
        CachedConnection cachedConnection;
        servers = new ArrayList<ThriftTransportKey>(servers);
        if (preferCachedConnection) {
            HashSet<ThriftTransportKey> serversSet = new HashSet<ThriftTransportKey>(servers);
            ThriftTransportPool thriftTransportPool = this;
            synchronized (thriftTransportPool) {
                serversSet.retainAll(this.getCache().keySet());
                if (serversSet.size() > 0) {
                    ArrayList<ThriftTransportKey> cachedServers = new ArrayList<ThriftTransportKey>(serversSet);
                    Collections.shuffle(cachedServers, random);
                    for (ThriftTransportKey ttk : cachedServers) {
                        cachedConnection = this.getCache().get(ttk).reserveAny();
                        if (cachedConnection == null) continue;
                        String serverAddr = ttk.getServer().toString();
                        log.trace("Using existing connection to {}", (Object)serverAddr);
                        return new Pair<String, TTransport>(serverAddr, cachedConnection.transport);
                    }
                }
            }
        }
        for (int retryCount = 0; servers.size() > 0 && retryCount < 10; ++retryCount) {
            int index = random.nextInt(servers.size());
            ThriftTransportKey ttk = servers.get(index);
            if (preferCachedConnection) {
                ThriftTransportPool thriftTransportPool = this;
                synchronized (thriftTransportPool) {
                    CachedConnections cachedConns = this.getCache().get(ttk);
                    if (cachedConns != null && (cachedConnection = cachedConns.reserveAny()) != null) {
                        String serverAddr = ttk.getServer().toString();
                        return new Pair<String, TTransport>(serverAddr, cachedConnection.transport);
                    }
                }
            }
            try {
                return new Pair<String, TTransport>(ttk.getServer().toString(), this.createNewTransport(ttk));
            }
            catch (TTransportException tte) {
                log.debug("Failed to connect to {}", (Object)servers.get(index), (Object)tte);
                servers.remove(index);
                continue;
            }
        }
        throw new TTransportException("Failed to connect to a server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport createNewTransport(ThriftTransportKey cacheKey) throws TTransportException {
        TTransport transport = ThriftUtil.createClientTransport(cacheKey.getServer(), (int)cacheKey.getTimeout(), cacheKey.getSslParams(), cacheKey.getSaslParams());
        log.trace("Creating new connection to connection to {}", (Object)cacheKey.getServer());
        CachedTTransport tsc = new CachedTTransport(transport, cacheKey);
        CachedConnection cc = new CachedConnection(tsc);
        cc.reserve();
        try {
            ThriftTransportPool thriftTransportPool = this;
            synchronized (thriftTransportPool) {
                CachedConnections cachedConns = this.getCache().get(cacheKey);
                if (cachedConns == null) {
                    cachedConns = new CachedConnections();
                    this.getCache().put(cacheKey, cachedConns);
                }
                cachedConns.reserved.put(cc.transport, cc);
            }
        }
        catch (TransportPoolShutdownException e) {
            cc.transport.close();
            throw e;
        }
        return cc.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTransport(TTransport tsc) {
        if (tsc == null) {
            return;
        }
        boolean existInCache = false;
        CachedTTransport ctsc = (CachedTTransport)tsc;
        ArrayList<CachedConnection> closeList = new ArrayList<CachedConnection>();
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            CachedConnection cachedConnection;
            CachedConnections cachedConns = this.getCache().get(ctsc.getCacheKey());
            if (cachedConns != null && (cachedConnection = cachedConns.reserved.remove((Object)ctsc)) != null) {
                if (ctsc.sawError) {
                    closeList.add(cachedConnection);
                    log.trace("Returned connection had error {}", (Object)ctsc.getCacheKey());
                    Long ecount = this.errorCount.get(ctsc.getCacheKey());
                    if (ecount == null) {
                        ecount = 0L;
                    }
                    Long l = ecount;
                    Long l2 = ecount = Long.valueOf(ecount + 1L);
                    this.errorCount.put(ctsc.getCacheKey(), ecount);
                    Long etime = this.errorTime.get(ctsc.getCacheKey());
                    if (etime == null) {
                        this.errorTime.put(ctsc.getCacheKey(), System.currentTimeMillis());
                    }
                    if (ecount >= ERROR_THRESHOLD && !this.serversWarnedAbout.contains(ctsc.getCacheKey())) {
                        log.warn("Server {} had {} failures in a short time period, will not complain anymore", (Object)ctsc.getCacheKey(), (Object)ecount);
                        this.serversWarnedAbout.add(ctsc.getCacheKey());
                    }
                    cachedConnection.unreserve();
                    closeList.addAll(cachedConns.unreserved);
                    cachedConns.unreserved.clear();
                } else {
                    log.trace("Returned connection {} ioCount: {}", (Object)ctsc.getCacheKey(), (Object)cachedConnection.transport.ioCount);
                    cachedConnection.lastReturnTime = System.currentTimeMillis();
                    cachedConnection.unreserve();
                    cachedConns.unreserved.addFirst(cachedConnection);
                }
                existInCache = true;
            }
        }
        for (CachedConnection cachedConnection : closeList) {
            try {
                cachedConnection.transport.close();
            }
            catch (Exception e) {
                log.debug("Failed to close connection w/ errors", (Throwable)e);
            }
        }
        if (!existInCache) {
            log.warn("Returned tablet server connection to cache that did not come from cache");
            tsc.close();
        }
    }

    public synchronized void setIdleTime(long time) {
        this.killTime = time;
        log.debug("Set thrift transport pool idle time to {}", (Object)time);
    }

    public static ThriftTransportPool getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TRANSPORT_POOL_PERMISSION);
        }
        if (daemonStarted.compareAndSet(false, true)) {
            CountDownLatch closerExitLatch = new CountDownLatch(1);
            new Daemon(new Closer(instance, closerExitLatch), "Thrift Connection Pool Checker").start();
            instance.setCloserExitLatch(closerExitLatch);
        }
        return instance;
    }

    private synchronized void setCloserExitLatch(CountDownLatch closerExitLatch) {
        this.closerExitLatch = closerExitLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            if (this.cache == null) {
                return;
            }
            for (CachedConnections cachedConn : this.getCache().values()) {
                for (CachedConnection cc : Iterables.concat(cachedConn.reserved.values(), cachedConn.unreserved)) {
                    try {
                        cc.transport.close();
                    }
                    catch (Exception e) {
                        log.debug("Error closing transport during shutdown", (Throwable)e);
                    }
                }
            }
            this.cache = null;
        }
        try {
            this.closerExitLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<ThriftTransportKey, CachedConnections> getCache() {
        if (this.cache == null) {
            throw new TransportPoolShutdownException();
        }
        return this.cache;
    }

    static class CachedTTransport
    extends TTransport {
        private ThriftTransportKey cacheKey;
        private TTransport wrappedTransport;
        private boolean sawError = false;
        private volatile String ioThreadName = null;
        private volatile long ioStartTime = 0L;
        private volatile boolean reserved = false;
        private String stuckThreadName = null;
        int ioCount = 0;
        int lastIoCount = -1;

        private void sawError(Exception e) {
            this.sawError = true;
        }

        final void setReserved(boolean reserved) {
            this.reserved = reserved;
            if (reserved) {
                this.ioThreadName = Thread.currentThread().getName();
                this.ioCount = 0;
                this.lastIoCount = -1;
            } else {
                if ((this.ioCount & 1) == 1) {
                    log.warn("Connection returned to thrift connection pool that may still be in use {} {}", new Object[]{this.ioThreadName, Thread.currentThread().getName(), new Exception()});
                }
                this.ioCount = 0;
                this.lastIoCount = -1;
                this.ioThreadName = null;
            }
            this.checkForStuckIO(120000L);
        }

        final void checkForStuckIO(long threshold) {
            if ((this.ioCount & 1) == 1) {
                if (this.ioCount == this.lastIoCount) {
                    long delta = System.currentTimeMillis() - this.ioStartTime;
                    if (delta >= threshold && this.stuckThreadName == null) {
                        this.stuckThreadName = this.ioThreadName;
                        log.warn("Thread \"{}\" stuck on IO to {} for at least {} ms", new Object[]{this.ioThreadName, this.cacheKey, delta});
                    }
                } else {
                    this.lastIoCount = this.ioCount;
                    this.ioStartTime = System.currentTimeMillis();
                    if (this.stuckThreadName != null) {
                        log.info("Thread \"{}\" no longer stuck on IO to {} sawError = {}", new Object[]{this.stuckThreadName, this.cacheKey, this.sawError});
                        this.stuckThreadName = null;
                    }
                }
            } else if (this.stuckThreadName != null) {
                log.info("Thread \"{}\" no longer stuck on IO to {} sawError = {}", new Object[]{this.stuckThreadName, this.cacheKey, this.sawError});
                this.stuckThreadName = null;
            }
        }

        public CachedTTransport(TTransport transport, ThriftTransportKey cacheKey2) {
            this.wrappedTransport = transport;
            this.cacheKey = cacheKey2;
        }

        public boolean isOpen() {
            return this.wrappedTransport.isOpen();
        }

        public void open() throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.open();
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int read(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.read(arg0, arg1, arg2);
                return n;
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int readAll(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.readAll(arg0, arg1, arg2);
                return n;
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void write(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.write(arg0, arg1, arg2);
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void write(byte[] arg0) throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.write(arg0);
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void close() {
            try {
                ++this.ioCount;
                this.wrappedTransport.close();
            }
            finally {
                ++this.ioCount;
            }
        }

        public void flush() throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.flush();
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public boolean peek() {
            try {
                ++this.ioCount;
                boolean bl = this.wrappedTransport.peek();
                return bl;
            }
            finally {
                ++this.ioCount;
            }
        }

        public byte[] getBuffer() {
            try {
                ++this.ioCount;
                byte[] byArray = this.wrappedTransport.getBuffer();
                return byArray;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int getBufferPosition() {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.getBufferPosition();
                return n;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int getBytesRemainingInBuffer() {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.getBytesRemainingInBuffer();
                return n;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void consumeBuffer(int len) {
            try {
                ++this.ioCount;
                this.wrappedTransport.consumeBuffer(len);
            }
            finally {
                ++this.ioCount;
            }
        }

        public ThriftTransportKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static class Closer
    implements Runnable {
        final ThriftTransportPool pool;
        private CountDownLatch closerExitLatch;

        public Closer(ThriftTransportPool pool, CountDownLatch closerExitLatch) {
            this.pool = pool;
            this.closerExitLatch = closerExitLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConnections() {
            while (true) {
                ArrayList<CachedConnection> connectionsToClose = new ArrayList<CachedConnection>();
                ThriftTransportPool thriftTransportPool = this.pool;
                synchronized (thriftTransportPool) {
                    for (CachedConnections cachedConns : this.pool.getCache().values()) {
                        Iterator iter = cachedConns.unreserved.iterator();
                        while (iter.hasNext()) {
                            CachedConnection cachedConnection = (CachedConnection)iter.next();
                            if (System.currentTimeMillis() - cachedConnection.lastReturnTime <= this.pool.killTime) continue;
                            connectionsToClose.add(cachedConnection);
                            iter.remove();
                        }
                        for (CachedConnection cachedConnection : cachedConns.reserved.values()) {
                            cachedConnection.transport.checkForStuckIO(120000L);
                        }
                    }
                    Iterator iter = this.pool.errorTime.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        long delta = System.currentTimeMillis() - (Long)entry.getValue();
                        if (delta < 120000L) continue;
                        this.pool.errorCount.remove(entry.getKey());
                        iter.remove();
                    }
                }
                for (CachedConnection cachedConnection : connectionsToClose) {
                    cachedConnection.transport.close();
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.debug("Sleep interrupted in closeConnections()", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            try {
                this.closeConnections();
            }
            catch (TransportPoolShutdownException transportPoolShutdownException) {
            }
            finally {
                this.closerExitLatch.countDown();
            }
        }
    }

    public static class TransportPoolShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    private static class CachedConnection {
        final CachedTTransport transport;
        long lastReturnTime;

        public CachedConnection(CachedTTransport t) {
            this.transport = t;
        }

        void reserve() {
            Preconditions.checkState((!this.transport.reserved ? 1 : 0) != 0);
            this.transport.setReserved(true);
        }

        void unreserve() {
            Preconditions.checkState((boolean)this.transport.reserved);
            this.transport.setReserved(false);
        }
    }

    private static class CachedConnections {
        LinkedList<CachedConnection> unreserved = new LinkedList();
        Map<CachedTTransport, CachedConnection> reserved = new HashMap<CachedTTransport, CachedConnection>();

        private CachedConnections() {
        }

        public CachedConnection reserveAny() {
            if (this.unreserved.size() > 0) {
                CachedConnection cachedConnection = this.unreserved.removeFirst();
                cachedConnection.reserve();
                this.reserved.put(cachedConnection.transport, cachedConnection);
                if (log.isTraceEnabled()) {
                    log.trace("Using existing connection to {}", (Object)cachedConnection.transport.cacheKey);
                }
                return cachedConnection;
            }
            return null;
        }
    }
}

