/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.slf4j.LoggerFactory;

public class NewTableConfiguration {
    private static final TimeType DEFAULT_TIME_TYPE = TimeType.MILLIS;
    private TimeType timeType = DEFAULT_TIME_TYPE;
    private boolean limitVersion = true;
    private Map<String, String> properties = new HashMap<String, String>();
    private SamplerConfiguration samplerConfiguration;

    public NewTableConfiguration setTimeType(TimeType tt) {
        Preconditions.checkArgument((tt != null ? 1 : 0) != 0, (Object)"TimeType is null");
        this.timeType = tt;
        return this;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public NewTableConfiguration withoutDefaultIterators() {
        this.limitVersion = false;
        return this;
    }

    public NewTableConfiguration setProperties(Map<String, String> prop) {
        Preconditions.checkArgument((prop != null ? 1 : 0) != 0, (Object)"properties is null");
        SamplerConfigurationImpl.checkDisjoint(prop, this.samplerConfiguration);
        try {
            LocalityGroupUtil.checkLocalityGroups(prop.entrySet());
        }
        catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
            LoggerFactory.getLogger(NewTableConfiguration.class).warn("Setting new table properties with bad locality group config.   Even though this warning was displayed, the properties were set. props:" + prop, (Throwable)e);
        }
        this.properties = new HashMap<String, String>(prop);
        return this;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (this.limitVersion) {
            propertyMap.putAll(IteratorUtil.generateInitialTableProperties(this.limitVersion));
        }
        if (this.samplerConfiguration != null) {
            propertyMap.putAll(new SamplerConfigurationImpl(this.samplerConfiguration).toTablePropertiesMap());
        }
        propertyMap.putAll(this.properties);
        return Collections.unmodifiableMap(propertyMap);
    }

    public NewTableConfiguration enableSampling(SamplerConfiguration samplerConfiguration) {
        Objects.requireNonNull(samplerConfiguration);
        SamplerConfigurationImpl.checkDisjoint(this.properties, samplerConfiguration);
        this.samplerConfiguration = samplerConfiguration;
        return this;
    }
}

