/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

public abstract class InputIndexOfStringNode
extends Node {
    public static InputIndexOfStringNode create() {
        return InputIndexOfStringNodeGen.create();
    }

    public abstract int execute(TruffleString var1, int var2, int var3, TruffleString var4, TruffleString.WithMask var5, Encodings.Encoding var6);

    @Specialization(guards={"mask == null"})
    public int doTString(TruffleString input, int fromIndex, int maxIndex, TruffleString match, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached TruffleString.ByteIndexOfStringNode indexOfStringNode) {
        int fromByteIndex = fromIndex << encoding.getStride();
        if (fromByteIndex >= input.byteLength(encoding.getTStringEncoding())) {
            return -1;
        }
        return indexOfStringNode.execute((AbstractTruffleString)input, (AbstractTruffleString)match, fromByteIndex, maxIndex << encoding.getStride(), encoding.getTStringEncoding()) >> encoding.getStride();
    }

    @Fallback
    public int doTStringMask(TruffleString input, int fromIndex, int maxIndex, TruffleString match, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached TruffleString.ByteIndexOfStringNode indexOfStringNode) {
        int fromByteIndex = fromIndex << encoding.getStride();
        if (fromByteIndex >= input.byteLength(encoding.getTStringEncoding())) {
            return -1;
        }
        return indexOfStringNode.execute((AbstractTruffleString)input, mask, fromByteIndex, maxIndex << encoding.getStride(), encoding.getTStringEncoding()) >> encoding.getStride();
    }
}

