/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetEstimate", value="_FUNC_(sketch)", extended="Returns an estimate of unique count from a given CpcSketch. The result is a double value.")
public class GetEstimateUDF
extends UDF {
    public Double evaluate(BytesWritable serializedSketch, long seed) {
        if (serializedSketch == null) {
            return null;
        }
        CpcSketch sketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), (long)seed);
        return sketch.getEstimate();
    }

    public Double evaluate(BytesWritable serializedSketch) {
        return this.evaluate(serializedSketch, 9001L);
    }
}

