/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.service.auth.ldap.LdapAuthService;
import org.eclipse.jetty.http.HttpMethod;

public class LDAPAuthenticationFilter
implements Filter {
    public static final String LOGIN_FORM_URI = "/loginForm.jsp";
    public static final String LOGIN_SERVLET_URI = "/login";
    private final LdapAuthService ldapAuthService;

    public LDAPAuthenticationFilter(LdapAuthService ldapAuthService) {
        this.ldapAuthService = ldapAuthService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean forwardRequest;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean isLoggedIn = this.ldapAuthService.authenticate(httpRequest, (HttpServletResponse)response);
        boolean bl = forwardRequest = this.isLoginRequest(httpRequest) == isLoggedIn;
        if (forwardRequest) {
            ServletContext rootContext = request.getServletContext().getContext("/");
            String forwardUri = isLoggedIn ? "/hiveserver2.jsp" : LOGIN_FORM_URI;
            RequestDispatcher dispatcher = rootContext.getRequestDispatcher(forwardUri);
            dispatcher.forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public boolean isLoginRequest(HttpServletRequest request) {
        String method = request.getMethod();
        String servletPath = request.getServletPath();
        return LOGIN_FORM_URI.equals(servletPath) || HttpMethod.POST.name().equalsIgnoreCase(method) && LOGIN_SERVLET_URI.equals(servletPath);
    }

    public void destroy() {
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }
}

