/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.mr.hive.vector.HiveBatchContext;
import org.apache.iceberg.mr.mapred.AbstractMapredIcebergRecordReader;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;

public final class HiveIcebergVectorizedRecordReader
extends AbstractMapredIcebergRecordReader<VectorizedRowBatch> {
    private final JobConf job;

    public HiveIcebergVectorizedRecordReader(IcebergInputFormat<VectorizedRowBatch> mapreduceInputFormat, IcebergSplit split, JobConf job, Reporter reporter) throws IOException {
        super(mapreduceInputFormat, split, job, reporter);
        this.job = job;
    }

    public boolean next(Void key, VectorizedRowBatch value) throws IOException {
        try {
            if (this.innerReader.nextKeyValue()) {
                HiveBatchContext currentValue = (HiveBatchContext)this.innerReader.getCurrentValue();
                VectorizedRowBatch newBatch = currentValue.getBatch();
                value.cols = newBatch.cols;
                value.endOfFile = newBatch.endOfFile;
                value.numCols = newBatch.numCols;
                value.projectedColumns = newBatch.projectedColumns;
                value.projectionSize = newBatch.projectionSize;
                value.selectedInUse = newBatch.selectedInUse;
                value.selected = newBatch.selected;
                value.size = newBatch.size;
                return true;
            }
            return false;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    public VectorizedRowBatch createValue() {
        return LlapHiveUtils.findMapWork((JobConf)this.job).getVectorizedRowBatchCtx().createVectorizedRowBatch();
    }

    public long getPos() {
        return -1L;
    }
}

