/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.udf;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.util.ZOrderByteUtils;

@Description(name="iceberg_zorder", value="_FUNC_(value) - Returns the z-value calculated by Iceberg ZOrderByteUtils class")
public class GenericUDFIcebergZorder
extends GenericUDF {
    private PrimitiveObjectInspector[] argOIs;
    private final int varLengthContribution = 8;
    private transient ByteBuffer[] reUseBuffer;
    private static final int MAX_OUTPUT_SIZE = Integer.MAX_VALUE;
    private static final byte[] NULL_ORDERED_BYTES = new byte[8];

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentException("iceberg_zorder requires at least 2 arguments");
        }
        this.argOIs = new PrimitiveObjectInspector[arguments.length];
        this.reUseBuffer = new ByteBuffer[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            ObjectInspector objectInspector = arguments[i];
            if (!(objectInspector instanceof PrimitiveObjectInspector)) {
                throw new UDFArgumentTypeException(i, "Only primitive types supported for z-order");
            }
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objectInspector;
            this.argOIs[i] = poi;
        }
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        byte[][] inputs = new byte[arguments.length][];
        int totalLength = 0;
        for (int i = 0; i < arguments.length; ++i) {
            byte[] orderedBytes = this.convertToOrderedBytes(arguments[i].get(), this.argOIs[i], i);
            inputs[i] = orderedBytes;
            totalLength += orderedBytes.length;
        }
        int outputLength = Math.min(totalLength, Integer.MAX_VALUE);
        ByteBuffer buffer = ByteBuffer.allocate(outputLength);
        byte[] interleaved = ZOrderByteUtils.interleaveBits(inputs, outputLength, buffer);
        return new BytesWritable(interleaved);
    }

    public String getDisplayString(String[] children) {
        return "iceberg_zorder(" + String.join((CharSequence)", ", children) + ")";
    }

    private byte[] convertToOrderedBytes(Object value, PrimitiveObjectInspector oi, int position) throws HiveException {
        if (value == null) {
            return NULL_ORDERED_BYTES;
        }
        if (this.reUseBuffer[position] == null) {
            this.reUseBuffer[position] = ByteBuffer.allocate(8);
        }
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                boolean boolValue = (Boolean)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.intToOrderedBytes(boolValue ? 1 : 0, this.reUseBuffer[position]).array();
            }
            case BYTE: {
                byte byteValue = (Byte)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.tinyintToOrderedBytes(byteValue, this.reUseBuffer[position]).array();
            }
            case SHORT: {
                short shortValue = (Short)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.shortToOrderedBytes(shortValue, this.reUseBuffer[position]).array();
            }
            case INT: {
                int intValue = (Integer)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.intToOrderedBytes(intValue, this.reUseBuffer[position]).array();
            }
            case LONG: {
                long longValue = (Long)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.longToOrderedBytes(longValue, this.reUseBuffer[position]).array();
            }
            case FLOAT: {
                float floatValue = ((Float)oi.getPrimitiveJavaObject(value)).floatValue();
                return ZOrderByteUtils.floatToOrderedBytes(floatValue, this.reUseBuffer[position]).array();
            }
            case DOUBLE: {
                double doubleValue = (Double)oi.getPrimitiveJavaObject(value);
                return ZOrderByteUtils.doubleToOrderedBytes(doubleValue, this.reUseBuffer[position]).array();
            }
            case DATE: {
                long epochDays;
                Object dateValue = oi.getPrimitiveJavaObject(value);
                if (dateValue instanceof Date) {
                    Date dd = (Date)dateValue;
                    epochDays = dd.toLocalDate().toEpochDay();
                } else if (dateValue instanceof org.apache.hadoop.hive.common.type.Date) {
                    org.apache.hadoop.hive.common.type.Date dd = (org.apache.hadoop.hive.common.type.Date)dateValue;
                    epochDays = dd.toEpochDay();
                } else {
                    throw new HiveException("Unsupported DATE backing type: " + String.valueOf(dateValue.getClass()));
                }
                return ZOrderByteUtils.longToOrderedBytes(epochDays, this.reUseBuffer[position]).array();
            }
            case TIMESTAMP: {
                long tsInMillis;
                Object tsValue = oi.getPrimitiveJavaObject(value);
                if (tsValue instanceof org.apache.hadoop.hive.common.type.Timestamp) {
                    org.apache.hadoop.hive.common.type.Timestamp ts = (org.apache.hadoop.hive.common.type.Timestamp)tsValue;
                    tsInMillis = ts.toEpochMilli();
                } else if (tsValue instanceof Timestamp) {
                    Timestamp ts = (Timestamp)tsValue;
                    tsInMillis = ts.getTime();
                } else {
                    throw new HiveException("Unsupported TIMESTAMP backing type: " + String.valueOf(tsValue.getClass()));
                }
                return ZOrderByteUtils.longToOrderedBytes(tsInMillis, this.reUseBuffer[position]).array();
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                String strVal = String.valueOf(oi.getPrimitiveJavaObject(value));
                return ZOrderByteUtils.stringToOrderedBytes(strVal, 8, this.reUseBuffer[position], StandardCharsets.UTF_8.newEncoder()).array();
            }
        }
        throw new HiveException("Unsupported type in z-order: " + String.valueOf(oi.getPrimitiveCategory()));
    }
}

