/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.LocalDate;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.util.DateTimeUtil;

public final class IcebergDateObjectInspectorHive3
extends AbstractPrimitiveJavaObjectInspector
implements DateObjectInspector,
WriteObjectInspector {
    private static final IcebergDateObjectInspectorHive3 INSTANCE = new IcebergDateObjectInspectorHive3();

    public static IcebergDateObjectInspectorHive3 get() {
        return INSTANCE;
    }

    private IcebergDateObjectInspectorHive3() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : Date.ofEpochDay((int)DateTimeUtil.daysFromDate((LocalDate)o));
    }

    public DateWritableV2 getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DateWritableV2(DateTimeUtil.daysFromDate((LocalDate)o));
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return new Date((Date)o);
        }
        if (o instanceof LocalDate) {
            return LocalDate.of(((LocalDate)o).getYear(), ((LocalDate)o).getMonth(), ((LocalDate)o).getDayOfMonth());
        }
        return o;
    }

    @Override
    public LocalDate convert(Object o) {
        if (o == null) {
            return null;
        }
        Date date = (Date)o;
        return LocalDate.of(date.getYear(), date.getMonth(), date.getDay());
    }
}

