/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.compaction.IcebergCompactionUtil;
import org.apache.iceberg.mr.hive.compaction.evaluator.HiveTableRuntime;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.CommonPartitionEvaluator;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.IcebergTableFileScanHelper;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.OptimizingConfig;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableConfiguration;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableFileScanHelper;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableFormat;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableRuntime;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableRuntimeMeta;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructProjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionEvaluator
extends CommonPartitionEvaluator {
    private static final long LAST_OPTIMIZE_TIME = 0L;
    private static final int TRIGGER_INTERVAL = -1;
    private final Table table;
    private final CompactionInfo ci;
    private static final Logger LOG = LoggerFactory.getLogger(CompactionEvaluator.class);

    public CompactionEvaluator(Table table, CompactionInfo ci, Map<String, String> parameters) throws IOException {
        super(CompactionEvaluator.createTableRuntime(table, parameters), CompactionEvaluator.getPartitionSpecStructPair(table, ci.partName), System.currentTimeMillis());
        this.table = table;
        this.ci = ci;
        this.addFiles();
    }

    public boolean isEligibleForCompaction() {
        if (this.table.currentSnapshot() == null) {
            LOG.info("Table {}{} doesn't require compaction because it is empty", (Object)this.table, this.ci.partName == null ? "" : " partition " + this.ci.partName);
            return false;
        }
        this.addFiles();
        switch (this.ci.type) {
            case MINOR: {
                return this.isMinorNecessary();
            }
            case MAJOR: {
                return this.isMajorNecessary();
            }
            case SMART_OPTIMIZE: {
                return this.isMinorNecessary() || this.isMajorNecessary();
            }
        }
        return false;
    }

    public CompactionType determineCompactionType() {
        if (this.ci.type == CompactionType.SMART_OPTIMIZE) {
            if (this.isMajorNecessary()) {
                return CompactionType.MAJOR;
            }
            if (this.isMinorNecessary()) {
                return CompactionType.MINOR;
            }
            return null;
        }
        return this.ci.type;
    }

    private static TableRuntime createTableRuntime(Table icebergTable, Map<String, String> parameters) {
        OptimizingConfig optimizingConfig = OptimizingConfig.parse(Collections.emptyMap());
        optimizingConfig.setTargetSize(CompactionEvaluator.getTargetSizeBytes(parameters));
        optimizingConfig.setFragmentRatio(CompactionEvaluator.getFragmentRatio(parameters));
        optimizingConfig.setMinTargetSizeRatio(CompactionEvaluator.getMinTargetSizeRatio(parameters));
        optimizingConfig.setMinorLeastFileCount(CompactionEvaluator.getMinInputFiles(parameters));
        optimizingConfig.setMajorDuplicateRatio(CompactionEvaluator.getDeleteFileRatio(parameters));
        optimizingConfig.setFullTriggerInterval(-1);
        optimizingConfig.setMinorLeastInterval(-1);
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.setOptimizingConfig(optimizingConfig);
        TableRuntimeMeta tableRuntimeMeta = new TableRuntimeMeta();
        tableRuntimeMeta.setTableName(icebergTable.name());
        tableRuntimeMeta.setFormat(TableFormat.ICEBERG);
        tableRuntimeMeta.setLastFullOptimizingTime(0L);
        tableRuntimeMeta.setLastMinorOptimizingTime(0L);
        tableRuntimeMeta.setTableConfig(tableConfig);
        return new HiveTableRuntime(tableRuntimeMeta);
    }

    private void addFiles() {
        IcebergTableFileScanHelper tableFileScanHelper = new IcebergTableFileScanHelper(this.table, this.table.currentSnapshot().snapshotId());
        try (CloseableIterable<TableFileScanHelper.FileScanResult> results = tableFileScanHelper.scan();){
            for (TableFileScanHelper.FileScanResult fileScanResult : results) {
                DataFile file = fileScanResult.file();
                if (!IcebergCompactionUtil.shouldIncludeForCompaction(this.table, this.ci.partName, file)) continue;
                this.addFile(fileScanResult.file(), fileScanResult.deleteFiles());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long getTargetSizeBytes(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("compactor.threshold.target.size")).map(Long::parseLong).orElse(0x8000000L);
    }

    public static double getMinTargetSizeRatio(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("compactor.threshold.min.target.size.ratio")).map(Double::parseDouble).orElse(0.75);
    }

    public static int getFragmentRatio(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("compactor.threshold.fragment.ratio")).map(x -> (int)(1.0 / Double.parseDouble(x))).orElse(8);
    }

    public static int getFragmentSizeBytes(Map<String, String> parameters) {
        return (int)((double)CompactionEvaluator.getTargetSizeBytes(parameters) * CompactionEvaluator.getMinTargetSizeRatio(parameters));
    }

    public static int getMinInputFiles(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("compactor.threshold.min.input.files")).map(Integer::parseInt).orElse(12);
    }

    public static double getDeleteFileRatio(Map<String, String> parameters) {
        return Optional.ofNullable(parameters.get("compactor.threshold.delete.file.ratio")).map(Double::parseDouble).orElse(0.1);
    }

    private static Pair<Integer, StructLike> getPartitionSpecStructPair(Table table, String partitionPath) throws IOException {
        if (!table.spec().isPartitioned() || partitionPath == null) {
            return null;
        }
        PartitionsTable partitionsTable = (PartitionsTable)MetadataTableUtils.createMetadataTableInstance(table, MetadataTableType.PARTITIONS);
        try (CloseableIterable fileScanTasks = partitionsTable.newScan().planFiles();){
            Pair pair = (Pair)FluentIterable.from(fileScanTasks).transformAndConcat(task -> task.asDataTask().rows()).transform(row -> {
                StructLike data = row.get(0, StructProjection.class);
                PartitionSpec spec = table.specs().get(row.get(1, Integer.class));
                PartitionData partitionData = IcebergTableUtil.toPartitionData(data, Partitioning.partitionType(table), spec.partitionType());
                String path = spec.partitionToPath(partitionData);
                return Maps.immutableEntry(path, Pair.of(spec.specId(), data));
            }).filter(e -> ((String)e.getKey()).equals(partitionPath)).transform(Map.Entry::getValue).get(0);
            return pair;
        }
    }
}

