/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.SortFieldDesc;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.SortFields;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.ZOrderFieldDesc;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.ZOrderFields;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hive.CatalogUtils;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHiveIcebergMetaHook
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHiveIcebergMetaHook.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    public static final Map<String, String> COMMON_HMS_PROPERTIES = ImmutableMap.of("table_type", "iceberg".toUpperCase());
    private static final Set<String> PARAMETERS_TO_REMOVE = ImmutableSet.of("iceberg.mr.table.schema", "location", "name", "iceberg.mr.table.partition.spec");
    static final String ORC_FILES_ONLY = "iceberg.orc.files.only";
    private static final String ZORDER_FIELDS_JSON_KEY = "zorderFields";
    protected final Configuration conf;
    protected Table icebergTable = null;
    protected Properties catalogProperties;
    protected boolean createHMSTableInHook = false;

    public BaseHiveIcebergMetaHook(Configuration conf) {
        this.conf = conf;
    }

    public void preCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        CreateTableRequest request = new CreateTableRequest(hmsTable);
        this.preCreateTable(request);
    }

    public void preCreateTable(CreateTableRequest request) {
        org.apache.hadoop.hive.metastore.api.Table hmsTable = request.getTable();
        if (hmsTable.isTemporary()) {
            throw new UnsupportedOperationException("Creation of temporary iceberg tables is not supported.");
        }
        this.catalogProperties = CatalogUtils.getCatalogProperties(hmsTable);
        hmsTable.getParameters().put("table_type", "iceberg".toUpperCase());
        if (!Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
            if (Boolean.parseBoolean(this.catalogProperties.getProperty("created_with_ctlt"))) {
                throw new UnsupportedOperationException("CTLT target table must be a HiveCatalog table.");
            }
            hmsTable.getSd().setInputFormat(HiveIcebergInputFormat.class.getCanonicalName());
            hmsTable.getSd().setOutputFormat(HiveIcebergOutputFormat.class.getCanonicalName());
            try {
                this.icebergTable = IcebergTableUtil.getTable(this.conf, this.catalogProperties, true);
                if (CatalogUtils.hadoopCatalog(this.conf, this.catalogProperties) && hmsTable.getSd() != null && hmsTable.getSd().getLocation() == null) {
                    hmsTable.getSd().setLocation(this.icebergTable.location());
                }
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.schema") == null, "Iceberg table already created - can not use provided schema");
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.partition.spec") == null, "Iceberg table already created - can not use provided partition specification");
                LOG.info("Iceberg table already exists {}", (Object)this.icebergTable);
                return;
            }
            catch (NoSuchTableException noSuchTableException) {
                // empty catch block
            }
        }
        Set<String> identifierFields = Optional.ofNullable(request.getPrimaryKeys()).map(primaryKeys -> primaryKeys.stream().map(SQLPrimaryKey::getColumn_name).collect(Collectors.toSet())).orElse(Collections.emptySet());
        Schema schema = this.schema(this.catalogProperties, hmsTable, identifierFields, request.getDefaultConstraints());
        PartitionSpec spec = BaseHiveIcebergMetaHook.spec(this.conf, schema, hmsTable);
        if (hmsTable.isSetPartitionKeys()) {
            hmsTable.getSd().getCols().addAll(hmsTable.getPartitionKeys());
            hmsTable.setPartitionKeysIsSet(false);
        }
        this.catalogProperties.put("iceberg.mr.table.schema", SchemaParser.toJson(schema));
        String specString = PartitionSpecParser.toJson(spec);
        this.catalogProperties.put("iceberg.mr.table.partition.spec", specString);
        this.validateCatalogConfigsDefined();
        if (request.getEnvContext() == null) {
            request.setEnvContext(new EnvironmentContext());
        }
        request.getEnvContext().putToProperties("default-partition-spec", specString);
        this.setCommonHmsTablePropertiesForIceberg(hmsTable);
        if (hmsTable.getParameters().containsKey("metadata_location")) {
            this.createHMSTableInHook = true;
        }
        BaseHiveIcebergMetaHook.assertFileFormat(this.catalogProperties.getProperty("write.format.default"));
        this.setOrcOnlyFilesParam(hmsTable);
        request.setPrimaryKeys(null);
        this.setSortOrder(hmsTable, schema, this.catalogProperties);
    }

    private void validateCatalogConfigsDefined() {
        String catalogName = this.catalogProperties.getProperty("iceberg.catalog");
        if (!StringUtils.isEmpty((CharSequence)catalogName) && !"location_based_table".equals(catalogName)) {
            boolean configsExist = !StringUtils.isEmpty((CharSequence)CatalogUtils.getCatalogType(this.conf, catalogName)) || !StringUtils.isEmpty((CharSequence)CatalogUtils.getCatalogImpl(this.conf, catalogName));
            Preconditions.checkArgument(configsExist, "Catalog type or impl must be set for catalog: %s", (Object)catalogName);
        }
    }

    private void setSortOrder(org.apache.hadoop.hive.metastore.api.Table hmsTable, Schema schema, Properties properties) {
        String sortOrderJSONString = (String)hmsTable.getParameters().get("default-sort-order");
        if (Strings.isNullOrEmpty(sortOrderJSONString)) {
            return;
        }
        if (this.isZOrderJSON(sortOrderJSONString)) {
            properties.remove("default-sort-order");
            this.setZOrderSortOrder(sortOrderJSONString, properties, hmsTable.getTableName());
            return;
        }
        try {
            SortFields sortFields = (SortFields)JSON_OBJECT_MAPPER.reader().readValue(sortOrderJSONString, SortFields.class);
            if (sortFields != null && !sortFields.getSortFields().isEmpty()) {
                SortOrder.Builder sortOrderBuilder = SortOrder.builderFor(schema);
                sortFields.getSortFields().forEach(fieldDesc -> {
                    NullOrder nullOrder = fieldDesc.getNullOrdering() == NullOrdering.NULLS_FIRST ? NullOrder.NULLS_FIRST : NullOrder.NULLS_LAST;
                    SortDirection sortDirection = fieldDesc.getDirection() == SortFieldDesc.SortDirection.ASC ? SortDirection.ASC : SortDirection.DESC;
                    sortOrderBuilder.sortBy(fieldDesc.getColumnName(), sortDirection, nullOrder);
                });
                properties.put("default-sort-order", SortOrderParser.toJson(sortOrderBuilder.build()));
            }
        }
        catch (Exception e) {
            LOG.warn("Can not read write order json: {}", (Object)sortOrderJSONString);
        }
    }

    private void setZOrderSortOrder(String jsonString, Properties properties, String tableName) {
        try {
            ZOrderFields zorderFields = (ZOrderFields)JSON_OBJECT_MAPPER.reader().readValue(jsonString, ZOrderFields.class);
            if (zorderFields != null && !zorderFields.getZOrderFields().isEmpty()) {
                List columnNames = zorderFields.getZOrderFields().stream().map(ZOrderFieldDesc::getColumnName).collect(Collectors.toList());
                properties.put("sort.order", "ZORDER");
                properties.put("sort.columns", String.join((CharSequence)",", columnNames));
                LOG.debug("Applying Z-ordering for Iceberg Table {} with Columns: {}", (Object)tableName, columnNames);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to parse Z-order sort order", (Throwable)e);
        }
    }

    private boolean isZOrderJSON(String jsonString) {
        try {
            JsonNode node = JSON_OBJECT_MAPPER.readTree(jsonString);
            return node.has(ZORDER_FIELDS_JSON_KEY);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void rollbackCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void preDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void rollbackDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean deleteData) {
    }

    public boolean createHMSTableInHook() {
        return this.createHMSTableInHook;
    }

    private static void assertFileFormat(String format) {
        if (format == null) {
            return;
        }
        String lowerCaseFormat = format.toLowerCase();
        Preconditions.checkArgument(Arrays.stream(FileFormat.values()).anyMatch(v -> lowerCaseFormat.contains(v.label)), String.format("Unsupported fileformat %s", format));
    }

    protected void setCommonHmsTablePropertiesForIceberg(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (CatalogUtils.isHadoopTable(this.conf, this.catalogProperties)) {
            String location;
            String string = location = hmsTable.getSd() != null ? hmsTable.getSd().getLocation() : null;
            if (location == null && CatalogUtils.hadoopCatalog(this.conf, this.catalogProperties)) {
                location = IcebergTableUtil.defaultWarehouseLocation(TableIdentifier.of(hmsTable.getDbName(), hmsTable.getTableName()), this.conf, this.catalogProperties);
                hmsTable.getSd().setLocation(location);
            }
            Preconditions.checkArgument(location != null, "Table location not set");
        }
        Map hmsParams = hmsTable.getParameters();
        COMMON_HMS_PROPERTIES.forEach(hmsParams::putIfAbsent);
        hmsParams.entrySet().removeIf(e -> e.getKey() == null || e.getValue() == null);
        PARAMETERS_TO_REMOVE.forEach(hmsParams::remove);
        this.setWriteModeDefaults(null, hmsParams, null);
    }

    protected Schema schema(Properties properties, org.apache.hadoop.hive.metastore.api.Table hmsTable, Set<String> identifierFields, List<SQLDefaultConstraint> sqlDefaultConstraints) {
        Map<String, String> defaultValues = Stream.ofNullable(sqlDefaultConstraints).flatMap(Collection::stream).collect(Collectors.toMap(SQLDefaultConstraint::getColumn_name, SQLDefaultConstraint::getDefault_value));
        boolean autoConversion = this.conf.getBoolean("iceberg.mr.schema.auto.conversion", false);
        if (properties.getProperty("iceberg.mr.table.schema") != null) {
            return SchemaParser.fromJson(properties.getProperty("iceberg.mr.table.schema"));
        }
        ArrayList<FieldSchema> cols = Lists.newArrayList(hmsTable.getSd().getCols());
        if (hmsTable.isSetPartitionKeys() && !hmsTable.getPartitionKeys().isEmpty()) {
            cols.addAll(hmsTable.getPartitionKeys());
        }
        Schema schema = HiveSchemaUtil.convert(cols, defaultValues, autoConversion);
        return this.getSchemaWithIdentifierFields(schema, identifierFields);
    }

    private Schema getSchemaWithIdentifierFields(Schema schema, Set<String> identifierFields) {
        if (identifierFields == null || identifierFields.isEmpty()) {
            return schema;
        }
        Set<Integer> identifierFieldIds = identifierFields.stream().map(column -> {
            Types.NestedField field = schema.findField((String)column);
            Preconditions.checkNotNull(field, "Cannot find identifier field ID for the column %s in schema %s", column, (Object)schema);
            return field.fieldId();
        }).collect(Collectors.toSet());
        List<Types.NestedField> cols = schema.columns().stream().map(column -> identifierFieldIds.contains(column.fieldId()) ? column.asRequired() : column).toList();
        return new Schema(cols, identifierFieldIds);
    }

    protected static PartitionSpec spec(Configuration configuration, Schema schema, org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        Preconditions.checkArgument(!hmsTable.isSetPartitionKeys() || hmsTable.getPartitionKeys().isEmpty(), "We can only handle non-partitioned Hive tables. The Iceberg schema should be in iceberg.mr.table.partition.spec or already converted to a partition transform ");
        PartitionSpec spec = IcebergTableUtil.spec(configuration, schema);
        if (spec != null) {
            Preconditions.checkArgument(hmsTable.getParameters().get("iceberg.mr.table.partition.spec") == null, "Provide only one of the following: Hive partition transform specification, or the iceberg.mr.table.partition.spec property");
            return spec;
        }
        return HMSTablePropertyHelper.getPartitionSpec(hmsTable.getParameters(), schema);
    }

    protected void setOrcOnlyFilesParam(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        hmsTable.getParameters().put(ORC_FILES_ONLY, String.valueOf(this.isOrcOnlyFiles(hmsTable)));
    }

    protected boolean isOrcOnlyFiles(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        return !"FALSE".equalsIgnoreCase((String)hmsTable.getParameters().get(ORC_FILES_ONLY)) && (hmsTable.getSd().getInputFormat() != null && hmsTable.getSd().getInputFormat().toUpperCase().contains(org.apache.iceberg.FileFormat.ORC.name()) || org.apache.iceberg.FileFormat.ORC.name().equalsIgnoreCase((String)hmsTable.getSd().getSerdeInfo().getParameters().get("write.format.default")) || org.apache.iceberg.FileFormat.ORC.name().equalsIgnoreCase((String)hmsTable.getParameters().get("write.format.default")));
    }

    protected void setWriteModeDefaults(Table icebergTbl, Map<String, String> newProps, EnvironmentContext context) {
        if ((icebergTbl == null || ((BaseTable)icebergTbl).operations().current().formatVersion() == 1) && IcebergTableUtil.isV2TableOrAbove(newProps)) {
            ImmutableList<String> writeModeList = ImmutableList.of("write.delete.mode", "write.update.mode", "write.merge.mode");
            writeModeList.stream().filter(writeMode -> this.catalogProperties.get(writeMode) == null).forEach(writeMode -> {
                this.catalogProperties.put(writeMode, RowLevelOperationMode.MERGE_ON_READ.modeName());
                newProps.put((String)writeMode, RowLevelOperationMode.MERGE_ON_READ.modeName());
            });
            if (context != null) {
                Splitter splitter = Splitter.on("'");
                Map contextProperties = context.getProperties();
                if (contextProperties.containsKey("set_properties")) {
                    String propValue = (String)context.getProperties().get("set_properties");
                    String writeModeStr = writeModeList.stream().filter(writeMode -> !splitter.splitToList(propValue).contains(writeMode)).collect(Collectors.joining("'"));
                    if (!writeModeStr.isEmpty()) {
                        contextProperties.put("set_properties", propValue + "'" + writeModeStr);
                    }
                }
            }
        }
    }

    public void postGetTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (hmsTable != null) {
            try {
                Table tbl = IcebergTableUtil.getTable(this.conf, hmsTable);
                String formatVersion = String.valueOf(((BaseTable)tbl).operations().current().formatVersion());
                hmsTable.getParameters().put("format-version", formatVersion);
                hmsTable.getSd().setInputFormat(HiveIcebergInputFormat.class.getName());
                hmsTable.getSd().setOutputFormat(HiveIcebergOutputFormat.class.getName());
                hmsTable.getSd().getSerdeInfo().setSerializationLib(HiveIcebergSerDe.class.getName());
                String storageHandler = (String)hmsTable.getParameters().get("storage_handler");
                if (storageHandler == null || !BaseHiveIcebergMetaHook.isHiveIcebergStorageHandler(storageHandler)) {
                    hmsTable.getParameters().put("storage_handler", "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler");
                }
            }
            catch (NoSuchTableException | NotFoundException runtimeException) {
                // empty catch block
            }
        }
    }

    private static boolean isHiveIcebergStorageHandler(String storageHandler) {
        try {
            Class<?> storageHandlerClass = Class.forName(storageHandler);
            return Class.forName("org.apache.iceberg.mr.hive.HiveIcebergStorageHandler").isAssignableFrom(storageHandlerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error checking storage handler class", e);
        }
    }

    public static enum FileFormat {
        ORC("orc"),
        PARQUET("parquet"),
        AVRO("avro");

        private final String label;

        private FileFormat(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

