/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.AddedRowsScanTask;
import org.apache.iceberg.BaseChangelogContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

class BaseAddedRowsScanTask
extends BaseChangelogContentScanTask<AddedRowsScanTask, DataFile>
implements AddedRowsScanTask {
    private final DeleteFile[] deletes;

    BaseAddedRowsScanTask(int changeOrdinal, long commitSnapshotId, DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        super(changeOrdinal, commitSnapshotId, file, schemaString, specString, residuals);
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
    }

    @Override
    protected AddedRowsScanTask self() {
        return this;
    }

    @Override
    protected AddedRowsScanTask newSplitTask(AddedRowsScanTask parentTask, long offset, long length) {
        return new SplitAddedRowsScanTask(parentTask, offset, length);
    }

    @Override
    public List<DeleteFile> deletes() {
        return ImmutableList.copyOf(this.deletes);
    }

    private static class SplitAddedRowsScanTask
    extends BaseChangelogContentScanTask.SplitScanTask<SplitAddedRowsScanTask, AddedRowsScanTask, DataFile>
    implements AddedRowsScanTask {
        SplitAddedRowsScanTask(AddedRowsScanTask parentTask, long offset, long length) {
            super(parentTask, offset, length);
        }

        @Override
        protected SplitAddedRowsScanTask copyWithNewLength(long newLength) {
            return new SplitAddedRowsScanTask((AddedRowsScanTask)this.parentTask(), this.start(), newLength);
        }

        @Override
        public List<DeleteFile> deletes() {
            return ((AddedRowsScanTask)this.parentTask()).deletes();
        }
    }
}

