/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractUUIDGenerator;

public class UUIDHexGenerator
extends AbstractUUIDGenerator {
    public UUIDHexGenerator(StoreManager storeMgr, String name) {
        super(storeMgr, name);
    }

    public static Class getStorageClass() {
        return String.class;
    }

    @Override
    protected String getIdentifier() {
        StringBuilder str = new StringBuilder(32);
        str.append(UUIDHexGenerator.getHexFromInt(IP_ADDRESS));
        str.append(UUIDHexGenerator.getHexFromInt(JVM_UNIQUE));
        short timeHigh = (short)(System.currentTimeMillis() >>> 32);
        str.append(UUIDHexGenerator.getHexFromShort(timeHigh));
        int timeLow = (int)System.currentTimeMillis();
        str.append(UUIDHexGenerator.getHexFromInt(timeLow));
        str.append(UUIDHexGenerator.getHexFromShort(this.getCount()));
        return str.toString();
    }

    private static String getHexFromInt(int val) {
        StringBuilder str = new StringBuilder("00000000");
        String hexstr = Integer.toHexString(val);
        str.replace(8 - hexstr.length(), 8, hexstr);
        return str.toString();
    }

    private static String getHexFromShort(short val) {
        StringBuilder str = new StringBuilder("0000");
        String hexstr = Integer.toHexString(val);
        str.replace(4 - hexstr.length(), 4, hexstr);
        return str.toString();
    }
}

