/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.MonthDay;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class MonthDayStringConverter
implements TypeConverter<MonthDay, String> {
    private static final long serialVersionUID = 8087124973147837116L;

    @Override
    public MonthDay toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return MonthDay.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, MonthDay.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(MonthDay md) {
        return md != null ? md.toString() : null;
    }
}

