/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class IntArrayByteBufferConverter
implements TypeConverter<int[], ByteBuffer> {
    private static final long serialVersionUID = -426707949213710681L;

    @Override
    public ByteBuffer toDatastoreType(int[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromIntArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return ArrayConversionHelper.getIntArrayFromByteArray(datastoreValue.array());
    }
}

