/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.cache.AbstractQueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheQueryResultCache
extends AbstractQueryResultsCache {
    private static final long serialVersionUID = -3967431477335678467L;
    private Cache cache;

    public JavaxCacheQueryResultCache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        try {
            CachingProvider cacheProvider = Caching.getCachingProvider();
            CacheManager cacheMgr = cacheProvider.getCacheManager();
            Cache tmpcache = cacheMgr.getCache(this.cacheName);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                cacheMgr.createCache(this.cacheName, (Configuration)cacheConfig);
                tmpcache = cacheMgr.getCache(this.cacheName);
            }
            this.cache = tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", e);
        }
    }

    @Override
    public void close() {
        try {
            this.cache.removeAll();
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
        this.cache = null;
    }

    @Override
    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    @Override
    public void evict(Class candidate) {
    }

    @Override
    public void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache(query, null);
        Iterator entryIter = this.cache.iterator();
        while (entryIter.hasNext()) {
            Cache.Entry entry = (Cache.Entry)entryIter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(baseKey)) continue;
            entryIter.remove();
        }
    }

    @Override
    public void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        this.cache.remove((Object)key);
    }

    @Override
    public void evictAll() {
        try {
            this.cache.removeAll();
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public List<Object> get(String queryKey) {
        return (List)this.cache.get((Object)queryKey);
    }

    @Override
    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            this.cache.put((Object)queryKey, results);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info("Query results with key '" + queryKey + "' not cached. " + re.getMessage());
        }
        return results;
    }
}

