/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import com.carrotsearch.hppc.ByteArrayDeque;
import com.google.flatbuffers.Table;
import com.lmax.disruptor.RingBuffer;
import io.jsonwebtoken.impl.DefaultJws;
import io.jsonwebtoken.io.JacksonSerializer;
import io.jsonwebtoken.security.Keys;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.util.NetUtil;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.log4j.config.Log4j1ConfigurationFactory;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.slf4j.Log4jLogger;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncTaskCopyLocalJars
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncTaskCopyLocalJars.class.getName());
    private final FileSystem rawFs;
    private final Path libDir;

    AsyncTaskCopyLocalJars(FileSystem rawFs, Path libDir) {
        this.rawFs = rawFs;
        this.libDir = libDir;
    }

    @Override
    public Void call() throws Exception {
        Class[] dependencies;
        for (Class c : dependencies = new Class[]{LlapDaemonProtocolProtos.class, LlapTezUtils.class, LlapInputFormat.class, HiveInputFormat.class, SslContextFactory.class, Rule.class, RegistryUtils.ServiceRecordMarshal.class, RingBuffer.class, org.apache.logging.log4j.Logger.class, Appender.class, Log4jLogger.class, Log4j1ConfigurationFactory.class, NetUtil.class, HttpObjectAggregator.class, HttpObjectAggregator.class, Table.class, ByteArrayDeque.class, Keys.class, DefaultJws.class, JacksonSerializer.class}) {
            Path jarPath = new Path(Utilities.jarFinderGetJar((Class)c));
            this.rawFs.copyFromLocalFile(jarPath, this.libDir);
            LOG.debug("Copying " + String.valueOf(jarPath) + " to " + String.valueOf(this.libDir));
        }
        return null;
    }
}

