/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileEstimateErrors;

public final class EvictionDispatcher
implements EvictionListener {
    private final LowLevelCache dataCache;
    private final SerDeLowLevelCacheImpl serdeCache;
    private final MetadataCache metadataCache;
    private final EvictionAwareAllocator allocator;

    public EvictionDispatcher(LowLevelCache dataCache, SerDeLowLevelCacheImpl serdeCache, MetadataCache metadataCache, EvictionAwareAllocator allocator) {
        this.dataCache = dataCache;
        this.metadataCache = metadataCache;
        this.serdeCache = serdeCache;
        this.allocator = allocator;
    }

    @Override
    public void notifyEvicted(LlapCacheableBuffer buffer) {
        buffer.notifyEvicted(this, false);
    }

    @Override
    public void notifyProactivelyEvicted(LlapCacheableBuffer buffer) {
        buffer.notifyEvicted(this, true);
    }

    public void notifyEvicted(SerDeLowLevelCacheImpl.LlapSerDeDataBuffer buffer, boolean isProactiveEviction) {
        this.serdeCache.notifyEvicted(buffer);
        this.requestDeallocation(buffer, isProactiveEviction);
    }

    public void notifyEvicted(LlapDataBuffer buffer, boolean isProactiveEviction) {
        this.dataCache.notifyEvicted(buffer);
        this.requestDeallocation(buffer, isProactiveEviction);
    }

    public void notifyEvicted(MetadataCache.LlapMetadataBuffer<?> buffer, boolean isProactiveEviction) {
        this.metadataCache.notifyEvicted(buffer);
        this.requestDeallocation(buffer, isProactiveEviction);
    }

    private void requestDeallocation(MemoryBuffer buffer, boolean isProactiveEviction) {
        if (isProactiveEviction) {
            this.allocator.deallocateProactivelyEvicted(buffer);
        } else {
            this.allocator.deallocateEvicted(buffer);
        }
    }

    public void notifyEvicted(OrcFileEstimateErrors buffer) {
        this.metadataCache.notifyEvicted(buffer);
    }
}

