/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.LoggerFactory;

public class ZooReservation {
    public static boolean attempt(IZooReaderWriter zk, String path, String reservationID, String debugInfo) throws KeeperException, InterruptedException {
        if (reservationID.contains(":")) {
            throw new IllegalArgumentException();
        }
        while (true) {
            try {
                zk.putPersistentData(path, (reservationID + ":" + debugInfo).getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
                return true;
            }
            catch (KeeperException.NodeExistsException nee) {
                byte[] zooData;
                Stat stat = new Stat();
                try {
                    zooData = zk.getData(path, stat);
                }
                catch (KeeperException.NoNodeException nne) {
                    continue;
                }
                String idInZoo = new String(zooData, StandardCharsets.UTF_8).split(":")[0];
                return idInZoo.equals(reservationID);
            }
            break;
        }
    }

    public static void release(IZooReaderWriter zk, String path, String reservationID) throws KeeperException, InterruptedException {
        byte[] zooData;
        try {
            zooData = zk.getData(path, null);
        }
        catch (KeeperException.NoNodeException e) {
            LoggerFactory.getLogger(ZooReservation.class).debug("Node does not exist " + path);
            return;
        }
        String zooDataStr = new String(zooData, StandardCharsets.UTF_8);
        String idInZoo = zooDataStr.split(":")[0];
        if (!idInZoo.equals(reservationID)) {
            throw new IllegalStateException("Tried to release reservation " + path + " with data mismatch " + reservationID + " " + zooDataStr);
        }
        zk.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
    }
}

