/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.TezClassLoader;
import org.apache.tez.dag.api.TezReflectionException;

@InterfaceAudience.Private
public final class ReflectionUtils {
    private static final Map<String, Class<?>> CLAZZ_CACHE = new ConcurrentHashMap();

    private ReflectionUtils() {
    }

    @InterfaceAudience.Private
    public static Class<?> getClazz(String className) throws TezReflectionException {
        Class<?> clazz = CLAZZ_CACHE.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new TezReflectionException("Unable to load class: " + className, e);
            }
        }
        return clazz;
    }

    private static <T> T getNewInstance(Class<T> clazz) throws TezReflectionException {
        T instance;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new TezReflectionException("Unable to instantiate class with 0 arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    private static <T> T getNewInstance(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) throws TezReflectionException {
        T instance;
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            instance = constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new TezReflectionException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    @InterfaceAudience.Private
    public static <T> T createClazzInstance(String className) throws TezReflectionException {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz);
        return (T)instance;
    }

    @InterfaceAudience.Private
    public static <T> T createClazzInstance(String className, Class<?>[] parameterTypes, Object[] parameters) throws TezReflectionException {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz, parameterTypes, parameters);
        return (T)instance;
    }

    @InterfaceAudience.Private
    public static <T> T invokeMethod(Object target, Method method, Object ... args) throws TezReflectionException {
        try {
            return (T)method.invoke(target, args);
        }
        catch (Exception e) {
            throw new TezReflectionException(e);
        }
    }

    @InterfaceAudience.Private
    public static Method getMethod(Class<?> targetClazz, String methodName, Class<?> ... parameterTypes) throws TezReflectionException {
        try {
            return targetClazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new TezReflectionException(e);
        }
    }

    @InterfaceAudience.Private
    public static synchronized void addResourcesToSystemClassLoader(List<URL> urls) {
        TezClassLoader classLoader = TezClassLoader.getInstance();
        for (URL url : urls) {
            classLoader.addURL(url);
        }
    }
}

