/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ReplayedTxnsForPolicyResult;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetReplayedTxnsForPolicyHandler
implements QueryHandler<ReplayedTxnsForPolicyResult> {
    private final String replPolicy;

    public GetReplayedTxnsForPolicyHandler(String replPolicy) {
        this.replPolicy = replPolicy;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT  \"RTM_SRC_TXN_ID\", \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE \"RTM_REPL_POLICY\" = :replPolicy";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("replPolicy", (Object)this.replPolicy);
    }

    public ReplayedTxnsForPolicyResult extractData(ResultSet rs) throws SQLException, DataAccessException {
        HashMap<String, String> result = new HashMap<String, String>();
        while (rs.next()) {
            long srcTxnId = rs.getLong("RTM_SRC_TXN_ID");
            long tgtTxnId = rs.getLong("RTM_TARGET_TXN_ID");
            result.put(String.valueOf(srcTxnId), String.valueOf(tgtTxnId));
        }
        return new ReplayedTxnsForPolicyResult(result);
    }
}

