/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.AbortedTxnHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.CompactionCandidateHandler;

public class FindPotentialCompactionsFunction
implements TransactionalFunction<Set<CompactionInfo>> {
    private final int fetchSize;
    private final int abortedThreshold;
    private final long abortedTimeThreshold;
    private final long lastChecked;
    private final boolean collectAbortedTxns;

    public FindPotentialCompactionsFunction(Configuration conf, int abortedThreshold, long abortedTimeThreshold, long lastChecked) {
        this.fetchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE);
        this.abortedThreshold = abortedThreshold;
        this.abortedTimeThreshold = abortedTimeThreshold;
        this.lastChecked = lastChecked;
        this.collectAbortedTxns = !MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
    }

    @Override
    public Set<CompactionInfo> execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        HashSet<CompactionInfo> candidates = new HashSet<CompactionInfo>((Collection)jdbcResource.execute(new CompactionCandidateHandler(this.lastChecked, this.fetchSize)));
        int remaining = this.fetchSize - candidates.size();
        if (this.collectAbortedTxns && remaining > 0) {
            candidates.addAll((Collection<CompactionInfo>)jdbcResource.execute(new AbortedTxnHandler(this.abortedTimeThreshold, this.abortedThreshold, remaining)));
        }
        return candidates;
    }
}

