/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;

public class SchemaToolTaskCreateLogsTable
extends SchemaToolTask {
    private String logPath;
    private String retentionPeriod;

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.logPath = cl.getOptionValue("createLogsTable");
        this.retentionPeriod = cl.getOptionValue("retentionPeriod") == null ? "7d" : cl.getOptionValue("retentionPeriod");
    }

    @Override
    void execute() throws HiveMetaException {
        this.schemaTool.testConnectionToMetastore();
        System.out.println("Starting creation of logs table");
        File scriptFile = this.generateLogsTableScript();
        String initScriptDir = scriptFile.getParent();
        String initScriptFile = scriptFile.getName();
        try {
            System.out.println("Initialization script " + initScriptFile);
            if (!this.schemaTool.isDryRun()) {
                this.schemaTool.execSql(initScriptDir, initScriptFile);
                System.out.println("Initialization script completed");
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("Logs table creation FAILED!", (Throwable)e);
        }
    }

    private File generateLogsTableScript() throws HiveMetaException {
        try {
            File tmpFile = File.createTempFile("schematool", ".sql");
            tmpFile.deleteOnExit();
            FileWriter fstream = new FileWriter(tmpFile.getPath());
            try (BufferedWriter out = new BufferedWriter(fstream);){
                out.write("USE SYS;" + System.getProperty("line.separator"));
                out.write("CREATE EXTERNAL TABLE logs");
                out.write(" (facility STRING, severity STRING,");
                out.write(" version STRING, ts TIMESTAMP, hostname STRING, app_name STRING,");
                out.write(" proc_id STRING, msg_id STRING, structured_data map<STRING,STRING>, msg BINARY,");
                out.write(" unmatched BINARY)");
                out.write(" PARTITIONED BY (dt DATE, ns STRING, app STRING)");
                out.write(" STORED BY 'org.apache.hadoop.hive.ql.log.syslog.SyslogStorageHandler'");
                out.write(" LOCATION '" + this.logPath + "'");
                out.write(" TBLPROPERTIES (\"partition.retention.period\"=\"" + this.retentionPeriod + "\");");
                out.write(System.getProperty("line.separator"));
            }
            return tmpFile;
        }
        catch (Exception err) {
            throw new HiveMetaException("Error generating logs table script", (Throwable)err);
        }
    }
}

