/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskAlterCatalog;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskCreateCatalog;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskCreateLogsTable;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskCreateUser;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskDrop;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskInfo;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskInit;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskInitOrUpgrade;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskMergeCatalog;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskMoveDatabase;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskMoveTable;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskUpgrade;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskValidate;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqlline.SqlLine;

public class MetastoreSchemaTool {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreSchemaTool.class);
    private static final String PASSWD_MASK = "[passwd stripped]";
    protected Configuration conf;
    protected String dbOpts = null;
    protected String dbType;
    protected String driver = null;
    protected boolean dryRun = false;
    protected String hiveDb;
    protected String hivePasswd;
    protected String hiveUser;
    protected String metaDbType;
    protected IMetaStoreSchemaInfo metaStoreSchemaInfo;
    protected boolean needsQuotedIdentifier;
    protected String quoteCharacter;
    protected String passWord = null;
    protected String url = null;
    protected String userName = null;
    protected URI[] validationServers = null;
    protected boolean verbose = false;
    protected SchemaToolCommandLine cmdLine;
    private static String homeDir;

    protected static String findHomeDir() {
        homeDir = homeDir == null ? System.getenv("METASTORE_HOME") : homeDir;
        return homeDir == null ? System.getenv("HIVE_HOME") : homeDir;
    }

    @VisibleForTesting
    public static void setHomeDirForTesting() {
        homeDir = System.getProperty("test.tmp.dir", "target/tmp");
    }

    @VisibleForTesting
    public MetastoreSchemaTool() {
    }

    @VisibleForTesting
    public void init(String metastoreHome, String[] args, OptionGroup additionalOptions, Configuration conf) throws HiveMetaException {
        try {
            this.cmdLine = new SchemaToolCommandLine(args, additionalOptions);
        }
        catch (ParseException e) {
            System.err.println("Failed to parse command line. ");
            throw new HiveMetaException((Throwable)e);
        }
        if (metastoreHome == null || metastoreHome.isEmpty()) {
            throw new HiveMetaException("No Metastore home directory provided");
        }
        this.conf = conf;
        this.dbType = this.cmdLine.getDbType();
        this.metaDbType = this.cmdLine.getMetaDbType();
        HiveSchemaHelper.NestedScriptParser parser = this.getDbCommandParser(this.dbType, this.metaDbType);
        this.needsQuotedIdentifier = parser.needsQuotedIdentifier();
        this.quoteCharacter = parser.getQuoteCharacter();
        this.metaStoreSchemaInfo = MetaStoreSchemaInfoFactory.get(conf, metastoreHome, this.dbType);
        if (this.dbType.equalsIgnoreCase("hive")) {
            this.url = "jdbc:hive2://?hive.conf.restricted.list=;hive.security.authorization.sqlstd.confwhitelist=.*;hive.security.authorization.sqlstd.confwhitelist.append=.*;hive.security.authorization.enabled=false;hive.metastore.uris=;hive.security.authorization.manager=org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdConfOnlyAuthorizerFactory;hive.support.concurrency=false;hive.txn.manager=org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;hive.metastore.rawstore.impl=org.apache.hadoop.hive.metastore.ObjectStore";
            this.driver = "org.apache.hive.jdbc.HiveDriver";
        }
        if (this.cmdLine.hasOption("userName")) {
            this.setUserName(this.cmdLine.getOptionValue("userName"));
        } else {
            this.setUserName(MetastoreConf.getAsString((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME));
        }
        if (this.cmdLine.hasOption("passWord")) {
            this.setPassWord(this.cmdLine.getOptionValue("passWord"));
        } else {
            try {
                this.setPassWord(MetastoreConf.getPassword((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD));
            }
            catch (IOException err) {
                throw new HiveMetaException("Error getting metastore password", (Throwable)err);
            }
        }
        if (this.cmdLine.hasOption("url")) {
            this.setUrl(this.cmdLine.getOptionValue("url"));
        }
        if (this.cmdLine.hasOption("driver")) {
            this.setDriver(this.cmdLine.getOptionValue("driver"));
        }
        if (this.cmdLine.hasOption("dryRun")) {
            this.setDryRun(true);
        }
        if (this.cmdLine.hasOption("verbose")) {
            this.setVerbose(true);
        }
        if (this.cmdLine.hasOption("dbOpts")) {
            this.setDbOpts(this.cmdLine.getOptionValue("dbOpts"));
        }
        if (this.cmdLine.hasOption("validate") && this.cmdLine.hasOption("servers")) {
            this.setValidationServers(this.cmdLine.getOptionValue("servers"));
        }
        if (this.cmdLine.hasOption("hiveUser")) {
            this.setHiveUser(this.cmdLine.getOptionValue("hiveUser"));
        }
        if (this.cmdLine.hasOption("hivePassword")) {
            this.setHivePasswd(this.cmdLine.getOptionValue("hivePassword"));
        }
        if (this.cmdLine.hasOption("hiveDb")) {
            this.setHiveDb(this.cmdLine.getOptionValue("hiveDb"));
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected String getDbType() {
        return this.dbType;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    protected boolean isDryRun() {
        return this.dryRun;
    }

    protected void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    public MetastoreSchemaTool setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    protected void setDbOpts(String dbOpts) {
        this.dbOpts = dbOpts;
    }

    protected URI[] getValidationServers() {
        return this.validationServers;
    }

    protected void setValidationServers(String servers) {
        if (StringUtils.isNotEmpty((CharSequence)servers)) {
            String[] strServers = servers.split(",");
            this.validationServers = new URI[strServers.length];
            for (int i = 0; i < this.validationServers.length; ++i) {
                this.validationServers[i] = new Path(strServers[i]).toUri();
            }
        }
    }

    protected String getHiveUser() {
        return this.hiveUser;
    }

    protected void setHiveUser(String hiveUser) {
        this.hiveUser = hiveUser;
    }

    protected String getHivePasswd() {
        return this.hivePasswd;
    }

    protected void setHivePasswd(String hivePasswd) {
        this.hivePasswd = hivePasswd;
    }

    protected String getHiveDb() {
        return this.hiveDb;
    }

    protected void setHiveDb(String hiveDb) {
        this.hiveDb = hiveDb;
    }

    protected SchemaToolCommandLine getCmdLine() {
        return this.cmdLine;
    }

    public Connection getConnectionToMetastore(boolean printInfo) throws HiveMetaException {
        return HiveSchemaHelper.getConnectionToMetastore(this.userName, this.passWord, this.url, this.driver, printInfo, this.conf, null);
    }

    protected HiveSchemaHelper.NestedScriptParser getDbCommandParser(String dbType, String metaDbType) {
        return HiveSchemaHelper.getDbCommandParser(dbType, this.dbOpts, this.userName, this.passWord, this.conf, null, true);
    }

    protected HiveSchemaHelper.MetaStoreConnectionInfo getConnectionInfo(boolean printInfo) {
        return new HiveSchemaHelper.MetaStoreConnectionInfo(this.userName, this.passWord, this.url, this.driver, printInfo, this.conf, this.dbType, this.hiveDb);
    }

    protected IMetaStoreSchemaInfo getMetaStoreSchemaInfo() {
        return this.metaStoreSchemaInfo;
    }

    @VisibleForTesting
    void verifySchemaVersion() throws HiveMetaException {
        if (this.dryRun) {
            return;
        }
        String newSchemaVersion = this.metaStoreSchemaInfo.getMetaStoreSchemaVersion(this.getConnectionInfo(false));
        this.assertCompatibleVersion(this.metaStoreSchemaInfo.getHiveSchemaVersion(), newSchemaVersion);
    }

    protected void assertCompatibleVersion(String hiveSchemaVersion, String dbSchemaVersion) throws HiveMetaException {
        if (!this.metaStoreSchemaInfo.isVersionCompatible(hiveSchemaVersion, dbSchemaVersion)) {
            throw new HiveMetaException("Metastore schema version is not compatible. Hive Version: " + hiveSchemaVersion + ", Database Schema Version: " + dbSchemaVersion);
        }
    }

    protected void execSql(String scriptDir, String scriptFile) throws IOException, HiveMetaException {
        this.execSql(scriptDir + File.separatorChar + scriptFile);
    }

    protected void execSql(String sqlScriptFile) throws IOException {
        CommandBuilder builder = new CommandBuilder(this.conf, this.url, this.driver, this.userName, this.passWord, sqlScriptFile).setVerbose(this.verbose);
        SqlLine sqlLine = new SqlLine();
        ByteArrayOutputStream outputForLog = null;
        if (!this.verbose) {
            Object out;
            if (LOG.isDebugEnabled()) {
                outputForLog = new ByteArrayOutputStream();
                out = outputForLog;
            } else {
                out = new NullOutputStream();
            }
            sqlLine.setOutputStream(new PrintStream((OutputStream)out));
            System.setProperty("sqlline.silent", "true");
        }
        LOG.info("Going to run command <" + builder.buildToLog() + ">");
        SqlLine.Status status = sqlLine.begin(builder.buildToRun(), null, false);
        if (LOG.isDebugEnabled() && outputForLog != null) {
            LOG.debug("Received following output from Sqlline:");
            LOG.debug(outputForLog.toString("UTF-8"));
        }
        if (status != SqlLine.Status.OK) {
            throw new IOException("Schema script failed, errorcode " + String.valueOf(status));
        }
    }

    protected void testConnectionToMetastore() throws HiveMetaException {
        Connection conn = this.getConnectionToMetastore(true);
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to close metastore connection", (Throwable)e);
        }
    }

    protected String quote(String stmt) {
        return MetastoreSchemaTool.quote(stmt, this.needsQuotedIdentifier, this.quoteCharacter);
    }

    public static String quote(String stmt, boolean needsQuotedIdentifier, String quoteCharacter) {
        stmt = stmt.replace("<q>", needsQuotedIdentifier ? quoteCharacter : "");
        stmt = stmt.replace("<qa>", quoteCharacter);
        return stmt;
    }

    private static void logAndPrintToError(String errmsg) {
        LOG.error(errmsg);
        System.err.println(errmsg);
    }

    public static void main(String[] args) {
        MetastoreSchemaTool tool = new MetastoreSchemaTool();
        ExitUtil.terminate((int)tool.run(args));
    }

    public int run(String[] args) {
        return this.run(MetastoreSchemaTool.findHomeDir(), args, null, MetastoreConf.newMetastoreConf());
    }

    @VisibleForTesting
    public final int runScript(String[] args, InputStream scriptStream) {
        try {
            this.init(MetastoreSchemaTool.findHomeDir(), args, null, MetastoreConf.newMetastoreConf());
            File scriptFile = File.createTempFile("schemaToolTmpScript", "sql");
            scriptFile.deleteOnExit();
            FileUtils.copyToFile((InputStream)scriptStream, (File)scriptFile);
            this.execSql(scriptFile.getAbsolutePath());
            return 0;
        }
        catch (IOException | HiveMetaException e) {
            throw new RuntimeException("Failed to run script " + String.valueOf(scriptStream), e);
        }
    }

    public int run(String metastoreHome, String[] args, OptionGroup additionalOptions, Configuration conf) {
        try {
            SchemaToolTask task;
            this.init(metastoreHome, args, additionalOptions, conf);
            if (this.cmdLine.hasOption("info")) {
                task = new SchemaToolTaskInfo();
            } else if (this.cmdLine.hasOption("upgradeSchema") || this.cmdLine.hasOption("upgradeSchemaFrom")) {
                task = new SchemaToolTaskUpgrade();
            } else if (this.cmdLine.hasOption("initSchema") || this.cmdLine.hasOption("initSchemaTo")) {
                task = new SchemaToolTaskInit();
            } else if (this.cmdLine.hasOption("initOrUpgradeSchema")) {
                task = new SchemaToolTaskInitOrUpgrade();
            } else if (this.cmdLine.hasOption("validate")) {
                task = new SchemaToolTaskValidate();
            } else if (this.cmdLine.hasOption("createCatalog")) {
                task = new SchemaToolTaskCreateCatalog();
            } else if (this.cmdLine.hasOption("alterCatalog")) {
                task = new SchemaToolTaskAlterCatalog();
            } else if (this.cmdLine.hasOption("mergeCatalog")) {
                task = new SchemaToolTaskMergeCatalog();
            } else if (this.cmdLine.hasOption("moveDatabase")) {
                task = new SchemaToolTaskMoveDatabase();
            } else if (this.cmdLine.hasOption("moveTable")) {
                task = new SchemaToolTaskMoveTable();
            } else if (this.cmdLine.hasOption("createUser")) {
                task = new SchemaToolTaskCreateUser();
            } else if (this.cmdLine.hasOption("dropAllDatabases")) {
                task = new SchemaToolTaskDrop();
            } else if (this.cmdLine.hasOption("createLogsTable")) {
                task = new SchemaToolTaskCreateLogsTable();
            } else {
                throw new HiveMetaException("No task defined!");
            }
            task.setHiveSchemaTool(this);
            task.setCommandLineArguments(this.cmdLine);
            task.execute();
            return 0;
        }
        catch (HiveMetaException e) {
            MetastoreSchemaTool.logAndPrintToError(e.getMessage());
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                MetastoreSchemaTool.logAndPrintToError("Underlying cause: " + t.getClass().getName() + " : " + t.getMessage());
                if (e.getCause() instanceof SQLException) {
                    MetastoreSchemaTool.logAndPrintToError("SQL Error code: " + ((SQLException)t).getErrorCode());
                }
            }
            if (this.cmdLine != null) {
                if (this.cmdLine.hasOption("verbose")) {
                    e.printStackTrace();
                } else {
                    MetastoreSchemaTool.logAndPrintToError("Use --verbose for detailed stacktrace.");
                }
            }
            MetastoreSchemaTool.logAndPrintToError("*** schemaTool failed ***");
            return 1;
        }
    }

    protected static class CommandBuilder {
        protected final String userName;
        protected final String password;
        protected final String sqlScriptFile;
        protected final String driver;
        protected final String url;
        private boolean verbose = false;

        protected CommandBuilder(Configuration conf, String url, String driver, String userName, String password, String sqlScriptFile) throws IOException {
            this.userName = userName;
            this.password = password;
            this.url = url == null ? HiveSchemaHelper.getValidConfVar(MetastoreConf.ConfVars.CONNECT_URL_KEY, conf) : url;
            this.driver = driver == null ? HiveSchemaHelper.getValidConfVar(MetastoreConf.ConfVars.CONNECTION_DRIVER, conf) : driver;
            this.sqlScriptFile = sqlScriptFile;
        }

        public CommandBuilder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public String[] buildToRun() throws IOException {
            return this.argsWith(this.password);
        }

        public String buildToLog() throws IOException {
            if (this.verbose) {
                this.logScript();
            }
            return StringUtils.join((Object[])this.argsWith(MetastoreSchemaTool.PASSWD_MASK), (String)" ");
        }

        protected String[] argsWith(String password) throws IOException {
            return new String[]{"-u", this.url, "-d", this.driver, "-n", this.userName, "-p", password, "--isolation=TRANSACTION_READ_COMMITTED", "-f", this.sqlScriptFile};
        }

        private void logScript() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to invoke file that contains:");
                try (BufferedReader reader = new BufferedReader(new FileReader(this.sqlScriptFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LOG.debug("script: " + line);
                    }
                }
            }
        }
    }
}

