/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Serializer
implements MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger((String)Serializer.class.getName());

    Serializer() {
    }

    @Override
    public String serialize(EventMessage message) {
        return this.serialize(MessageSerializer.super.serialize(message));
    }

    @Override
    public String serialize(String msg) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gout = new GZIPOutputStream(baos);
            gout.write(msg.getBytes(StandardCharsets.UTF_8));
            gout.close();
            byte[] compressed = baos.toByteArray();
            string = new String(Base64.getEncoder().encode(compressed), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("could not use gzip output stream", (Throwable)e);
                LOG.debug("message " + msg);
                throw new RuntimeException("could not use the gzip output Stream", e);
            }
        }
        baos.close();
        return string;
    }
}

