/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.events.CommitCompactionEvent;
import org.apache.hadoop.hive.metastore.messaging.CommitCompactionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;

public class JSONCommitCompactionMessage
extends CommitCompactionMessage {
    @JsonProperty
    private Long txnid;
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private Long compactionId;
    @JsonProperty
    private CompactionType type;
    @JsonProperty
    private String dbname;
    @JsonProperty
    private String tableName;
    @JsonProperty
    private String partName;

    public JSONCommitCompactionMessage() {
    }

    public JSONCommitCompactionMessage(String server, String servicePrincipal, long timestamp, CommitCompactionEvent event) {
        this.timestamp = timestamp;
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.txnid = event.getTxnId();
        this.compactionId = event.getCompactionId();
        this.type = event.getType();
        this.dbname = event.getDbname();
        this.tableName = event.getTableName();
        this.partName = event.getPartName();
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getDB() {
        return this.dbname;
    }

    @Override
    public Long getTxnId() {
        return this.txnid;
    }

    @Override
    public Long getCompactionId() {
        return this.compactionId;
    }

    @Override
    public CompactionType getType() {
        return this.type;
    }

    @Override
    public String getDbname() {
        return this.dbname;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

