/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringColumnStatsMerger
extends ColumnStatsMerger<String> {
    private static final Logger LOG = LoggerFactory.getLogger(StringColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        StringColumnStatsDataInspector aggregateData = ColumnsStatsUtils.stringInspectorFromStats(aggregateColStats);
        StringColumnStatsDataInspector newData = ColumnsStatsUtils.stringInspectorFromStats(newColStats);
        aggregateData.setMaxColLen(this.mergeMaxColLen(aggregateData.getMaxColLen(), newData.getMaxColLen()));
        aggregateData.setAvgColLen(this.mergeAvgColLen(aggregateData.getAvgColLen(), newData.getAvgColLen()));
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        aggregateColStats.getStatsData().setStringStats((StringColumnStatsData)aggregateData);
    }
}

