/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.List;

public class GetPartitionsArgs {
    private String filter;
    private byte[] expr;
    private String defaultPartName;
    private int max;
    private List<String> partNames;
    private List<String> part_vals;
    private String userName;
    private List<String> groupNames;
    private String includeParamKeyPattern;
    private String excludeParamKeyPattern;
    private boolean skipColumnSchemaForPartition;

    private GetPartitionsArgs() {
    }

    public String getFilter() {
        return this.filter;
    }

    public byte[] getExpr() {
        return this.expr;
    }

    public String getDefaultPartName() {
        return this.defaultPartName;
    }

    public int getMax() {
        return this.max;
    }

    public List<String> getPartNames() {
        return this.partNames;
    }

    public List<String> getPart_vals() {
        return this.part_vals;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public String getIncludeParamKeyPattern() {
        return this.includeParamKeyPattern;
    }

    public String getExcludeParamKeyPattern() {
        return this.excludeParamKeyPattern;
    }

    public boolean isSkipColumnSchemaForPartition() {
        return this.skipColumnSchemaForPartition;
    }

    public static GetPartitionsArgs getAllPartitions() {
        return new GetPartitionsArgsBuilder().max(-1).build();
    }

    public static class GetPartitionsArgsBuilder {
        private String filter;
        private byte[] expr;
        private String defaultPartName;
        private int max = -1;
        private List<String> partNames;
        private List<String> part_vals;
        private String userName;
        private List<String> groupNames;
        private String includeParamKeyPattern;
        private String excludeParamKeyPattern;
        private boolean skipColumnSchemaForPartition = false;

        public GetPartitionsArgsBuilder() {
        }

        public GetPartitionsArgsBuilder(GetPartitionsArgs args) {
            this.filter = args.filter;
            this.expr = args.expr;
            this.defaultPartName = args.defaultPartName;
            this.max = args.max;
            this.partNames = args.partNames;
            this.part_vals = args.part_vals;
            this.userName = args.userName;
            this.groupNames = args.groupNames;
            this.includeParamKeyPattern = args.includeParamKeyPattern;
            this.excludeParamKeyPattern = args.excludeParamKeyPattern;
            this.skipColumnSchemaForPartition = args.skipColumnSchemaForPartition;
        }

        public GetPartitionsArgsBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public GetPartitionsArgsBuilder expr(byte[] expr) {
            this.expr = expr;
            return this;
        }

        public GetPartitionsArgsBuilder defaultPartName(String defaultPartName) {
            this.defaultPartName = defaultPartName;
            return this;
        }

        public GetPartitionsArgsBuilder max(int max) {
            this.max = max;
            return this;
        }

        public GetPartitionsArgsBuilder partNames(List<String> partNames) {
            this.partNames = partNames;
            return this;
        }

        public GetPartitionsArgsBuilder part_vals(List<String> part_vals) {
            this.part_vals = part_vals;
            return this;
        }

        public GetPartitionsArgsBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public GetPartitionsArgsBuilder groupNames(List<String> groupNames) {
            this.groupNames = groupNames;
            return this;
        }

        public GetPartitionsArgsBuilder includeParamKeyPattern(String includeParamKeyPattern) {
            this.includeParamKeyPattern = includeParamKeyPattern;
            return this;
        }

        public GetPartitionsArgsBuilder excludeParamKeyPattern(String excludeParamKeyPattern) {
            this.excludeParamKeyPattern = excludeParamKeyPattern;
            return this;
        }

        public GetPartitionsArgsBuilder skipColumnSchemaForPartition(boolean skipColumnSchemaForPartition) {
            this.skipColumnSchemaForPartition = skipColumnSchemaForPartition;
            return this;
        }

        public GetPartitionsArgs build() {
            GetPartitionsArgs additionalArgs = new GetPartitionsArgs();
            additionalArgs.filter = this.filter;
            additionalArgs.expr = this.expr;
            additionalArgs.defaultPartName = this.defaultPartName;
            additionalArgs.max = this.max;
            additionalArgs.partNames = this.partNames;
            additionalArgs.part_vals = this.part_vals;
            additionalArgs.userName = this.userName;
            additionalArgs.groupNames = this.groupNames;
            additionalArgs.includeParamKeyPattern = this.includeParamKeyPattern;
            additionalArgs.excludeParamKeyPattern = this.excludeParamKeyPattern;
            additionalArgs.skipColumnSchemaForPartition = this.skipColumnSchemaForPartition;
            return additionalArgs;
        }
    }
}

