/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth;

import java.util.Optional;

public class HttpAuthenticationException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final int statusCode;
    private final String wwwAuthenticateHeader;

    public HttpAuthenticationException(String msg) {
        this(msg, null);
    }

    public HttpAuthenticationException(String msg, Throwable cause) {
        this(msg, cause, 401);
    }

    public HttpAuthenticationException(String msg, Throwable cause, int statusCode) {
        this(msg, cause, statusCode, null);
    }

    public HttpAuthenticationException(String msg, int statusCode, String wwwAuthenticateHeader) {
        this(msg, null, statusCode, wwwAuthenticateHeader);
    }

    public HttpAuthenticationException(String msg, Throwable cause, int statusCode, String wwwAuthenticateHeader) {
        super(msg, cause);
        this.statusCode = statusCode;
        this.wwwAuthenticateHeader = wwwAuthenticateHeader;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getWwwAuthenticateHeader() {
        return Optional.ofNullable(this.wwwAuthenticateHeader);
    }
}

