/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.thrift.TException;

public final class ExceptionHandler {
    private final Exception e;

    private ExceptionHandler(Exception e) {
        this.e = e;
    }

    public static ExceptionHandler handleException(Exception e) {
        Objects.requireNonNull(e, "Exception e is null");
        return new ExceptionHandler(e);
    }

    public <T extends Exception> ExceptionHandler throwIfInstance(Class<T> t) throws T {
        if (t.isInstance(this.e)) {
            throw (Exception)t.cast(this.e);
        }
        return this;
    }

    public <T1 extends Exception, T2 extends Exception> ExceptionHandler throwIfInstance(Class<T1> te1, Class<T2> te2) throws T1, T2 {
        this.throwIfInstance(te1);
        this.throwIfInstance(te2);
        return this;
    }

    public <T1 extends Exception, T2 extends Exception, T3 extends Exception> ExceptionHandler throwIfInstance(Class<T1> te1, Class<T2> te2, Class<T3> te3) throws T1, T2, T3 {
        this.throwIfInstance(te1);
        this.throwIfInstance(te2);
        this.throwIfInstance(te3);
        return this;
    }

    public <S extends Exception, T extends TException> ExceptionHandler convertIfInstance(Class<S> source, Class<T> target) throws T {
        TException targetException = null;
        if (source.isInstance(this.e)) {
            try {
                targetException = (TException)JavaUtils.newInstance(target, (Class[])new Class[]{String.class}, (Object[])new Object[]{this.e.getMessage()});
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (targetException != null) {
            throw targetException;
        }
        return this;
    }

    public ExceptionHandler toMetaExceptionIfInstance(String message, Class<?> ... clzs) throws MetaException {
        if (clzs != null && clzs.length > 0) {
            for (Class<?> clz : clzs) {
                if (!clz.isInstance(this.e)) continue;
                throw new MetaException(message);
            }
        }
        return this;
    }

    public static void rethrowException(Exception e) throws TException {
        throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).throwIfInstance(TException.class).defaultMetaException();
    }

    public static void throwMetaException(Exception e) throws MetaException, NoSuchObjectException {
        throw ExceptionHandler.handleException(e).throwIfInstance(MetaException.class, NoSuchObjectException.class).defaultMetaException();
    }

    public static MetaException newMetaException(Exception e) {
        if (e instanceof MetaException) {
            return (MetaException)e;
        }
        MetaException me = new MetaException(e.toString());
        me.initCause((Throwable)e);
        return me;
    }

    public RuntimeException defaultRuntimeException() {
        if (this.e instanceof RuntimeException) {
            return (RuntimeException)this.e;
        }
        return new RuntimeException(this.e);
    }

    public MetaException defaultMetaException() {
        return ExceptionHandler.newMetaException(this.e);
    }

    public TException defaultTException() {
        if (this.e instanceof TException) {
            return (TException)this.e;
        }
        return ExceptionHandler.newMetaException(this.e);
    }
}

