/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hive.common.util.SuppressFBWarnings;

public class NonSyncByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public NonSyncByteArrayOutputStream(int size) {
        super(size);
    }

    public NonSyncByteArrayOutputStream() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Ref external obj for efficiency")
    public byte[] getData() {
        return this.buf;
    }

    public int getLength() {
        return this.count;
    }

    public void setWritePosition(int writePosition) {
        this.count = writePosition;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public void write(DataInput in, int length) throws IOException {
        this.enLargeBuffer(length);
        in.readFully(this.buf, this.count, length);
        this.count += length;
    }

    @Override
    public void write(int b) {
        this.enLargeBuffer(1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    private void enLargeBuffer(int increment) {
        int currentCapacity;
        int requestCapacity = Math.addExact(this.count, increment);
        if (requestCapacity > (currentCapacity = this.buf.length)) {
            int newCapacity = currentCapacity + (currentCapacity >> 1);
            if (newCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                newCapacity = 0x7FFFFFF7;
            } else if (newCapacity < requestCapacity) {
                newCapacity = requestCapacity;
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.enLargeBuffer(len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

