/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DelegationTokenCache<JobId, TokenObject> {
    private ConcurrentHashMap<JobId, TokenObject> tokenCache = new ConcurrentHashMap();
    private static final DelegationTokenCache<String, String> stringFormTokenCache = new DelegationTokenCache();

    public static DelegationTokenCache<String, String> getStringFormTokenCache() {
        return stringFormTokenCache;
    }

    TokenObject storeDelegationToken(JobId jobId, TokenObject token) {
        return this.tokenCache.put(jobId, token);
    }

    public TokenObject getDelegationToken(JobId jobId) {
        return this.tokenCache.get(jobId);
    }

    public void removeDelegationToken(JobId jobId) {
        this.tokenCache.remove(jobId);
    }
}

