/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopDelegator
extends LauncherDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopDelegator.class);

    public SqoopDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, String command, String optionsFile, String otherFiles, String statusdir, String callback, String completedUrl, boolean enablelog, Boolean enableJobReconnect, String libdir) throws NotAuthorizedException, BadParam, BusyException, QueueException, IOException, InterruptedException, TooManyRequestsException {
        if (TempletonUtils.isset(this.appConf.sqoopArchive()) && !TempletonUtils.isset(this.appConf.sqoopPath()) && !TempletonUtils.isset(this.appConf.sqoopHome())) {
            throw new IllegalStateException("If 'templeton.sqoop.archive' is defined, 'templeton.sqoop.path' and 'templeton.sqoop.home' must be defined");
        }
        this.runAs = user;
        List<String> args = this.makeArgs(command, optionsFile, otherFiles, statusdir, completedUrl, enablelog, enableJobReconnect, libdir);
        return this.enqueueController(user, userArgs, callback, args);
    }

    private List<String> makeArgs(String command, String optionsFile, String otherFiles, String statusdir, String completedUrl, boolean enablelog, Boolean enableJobReconnect, String libdir) throws BadParam, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        try {
            args.addAll(this.makeBasicArgs(optionsFile, otherFiles, statusdir, completedUrl, enablelog, enableJobReconnect, libdir));
            args.add("--");
            args.add(this.appConf.sqoopPath());
            if (TempletonUtils.isset(command)) {
                String[] temArgs = command.split(" ");
                for (int i = 0; i < temArgs.length; ++i) {
                    args.add(temArgs[i]);
                    if (i == 0 && !temArgs[i].startsWith("--")) {
                        args.add("-D__MR_JOB_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION__");
                        args.add("-D__MR_JOB_TAGS_OPTION=MR_JOB_TAGS_JOBID__");
                    }
                    if (i != 0 || !TempletonUtils.isset(libdir) || !TempletonUtils.isset(this.appConf.sqoopArchive())) continue;
                    String libJars = null;
                    for (String s : args) {
                        if (!s.startsWith("templeton.sqoop.lib.jar")) continue;
                        libJars = s.substring(s.indexOf("=") + 1);
                        break;
                    }
                    args.add("-libjars");
                    args.add(libJars);
                }
            } else if (TempletonUtils.isset(optionsFile)) {
                args.add("--options-file");
                args.add(TempletonUtils.hadoopFsPath(optionsFile, this.appConf, this.runAs).getName());
            }
        }
        catch (FileNotFoundException e) {
            throw new BadParam(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BadParam(e.getMessage());
        }
        return args;
    }

    private List<String> makeBasicArgs(String optionsFile, String otherFiles, String statusdir, String completedUrl, boolean enablelog, Boolean enableJobReconnect, String libdir) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> allFiles = new ArrayList<String>();
        if (TempletonUtils.isset(optionsFile)) {
            allFiles.add(TempletonUtils.hadoopFsFilename(optionsFile, this.appConf, this.runAs));
        }
        if (TempletonUtils.isset(otherFiles)) {
            String[] ofs = TempletonUtils.hadoopFsListAsArray(otherFiles, this.appConf, this.runAs);
            allFiles.addAll(Arrays.asList(ofs));
        }
        if (TempletonUtils.isset(libdir) && TempletonUtils.isset(this.appConf.sqoopArchive())) {
            LOG.debug("libdir=" + libdir);
            List<Path> jarList = TempletonUtils.hadoopFsListChildren(libdir, this.appConf, this.runAs);
            if (TempletonUtils.isset(jarList)) {
                StringBuilder sb = new StringBuilder();
                for (Path jar : jarList) {
                    allFiles.add(jar.toString());
                    sb.append(jar.getName()).append(',');
                }
                sb.setLength(sb.length() - 1);
                SqoopDelegator.addDef(args, "templeton.sqoop.lib.jar", sb.toString());
                SqoopDelegator.addDef(args, "templeton.sqoop.home", this.appConf.get("templeton.sqoop.home"));
            }
        }
        args.addAll(this.makeLauncherArgs(this.appConf, statusdir, completedUrl, allFiles, enablelog, enableJobReconnect, LauncherDelegator.JobType.SQOOP));
        if (TempletonUtils.isset(this.appConf.sqoopArchive())) {
            args.add("-archives");
            args.add(this.appConf.sqoopArchive());
        }
        return args;
    }
}

