/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.FileDump;

public class PrintData {
    private static void printMap(JsonWriter writer, MapColumnVector vector, TypeDescription schema, int row) throws IOException {
        writer.beginArray();
        TypeDescription keyType = (TypeDescription)schema.getChildren().get(0);
        TypeDescription valueType = (TypeDescription)schema.getChildren().get(1);
        int offset = (int)vector.offsets[row];
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            writer.beginObject();
            writer.name("_key");
            PrintData.printValue(writer, vector.keys, keyType, offset + i);
            writer.name("_value");
            PrintData.printValue(writer, vector.values, valueType, offset + i);
            writer.endObject();
            ++i;
        }
        writer.endArray();
    }

    private static void printList(JsonWriter writer, ListColumnVector vector, TypeDescription schema, int row) throws IOException {
        writer.beginArray();
        int offset = (int)vector.offsets[row];
        TypeDescription childType = (TypeDescription)schema.getChildren().get(0);
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            PrintData.printValue(writer, vector.child, childType, offset + i);
            ++i;
        }
        writer.endArray();
    }

    private static void printUnion(JsonWriter writer, UnionColumnVector vector, TypeDescription schema, int row) throws IOException {
        int tag = vector.tags[row];
        PrintData.printValue(writer, vector.fields[tag], (TypeDescription)schema.getChildren().get(tag), row);
    }

    static void printStruct(JsonWriter writer, StructColumnVector batch, TypeDescription schema, int row) throws IOException {
        writer.beginObject();
        List fieldNames = schema.getFieldNames();
        List fieldTypes = schema.getChildren();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            writer.name((String)fieldNames.get(i));
            PrintData.printValue(writer, batch.fields[i], (TypeDescription)fieldTypes.get(i), row);
        }
        writer.endObject();
    }

    static void printBinary(JsonWriter writer, BytesColumnVector vector, int row) throws IOException {
        writer.beginArray();
        int offset = vector.start[row];
        for (int i = 0; i < vector.length[row]; ++i) {
            writer.value((long)(0xFF & vector.vector[row][offset + i]));
        }
        writer.endArray();
    }

    static void printValue(JsonWriter writer, ColumnVector vector, TypeDescription schema, int row) throws IOException {
        block16: {
            block15: {
                if (vector.isRepeating) {
                    row = 0;
                }
                if (!vector.noNulls && vector.isNull[row]) break block15;
                switch (schema.getCategory()) {
                    case BOOLEAN: {
                        writer.value(((LongColumnVector)vector).vector[row] != 0L);
                        break block16;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        writer.value(((LongColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        writer.value(((DoubleColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        writer.value(((BytesColumnVector)vector).toString(row));
                        break block16;
                    }
                    case BINARY: {
                        PrintData.printBinary(writer, (BytesColumnVector)vector, row);
                        break block16;
                    }
                    case DECIMAL: {
                        writer.value(((DecimalColumnVector)vector).vector[row].toString());
                        break block16;
                    }
                    case DATE: {
                        writer.value(new DateWritable((int)((LongColumnVector)vector).vector[row]).toString());
                        break block16;
                    }
                    case TIMESTAMP: 
                    case TIMESTAMP_INSTANT: {
                        writer.value(((TimestampColumnVector)vector).asScratchTimestamp(row).toString());
                        break block16;
                    }
                    case LIST: {
                        PrintData.printList(writer, (ListColumnVector)vector, schema, row);
                        break block16;
                    }
                    case MAP: {
                        PrintData.printMap(writer, (MapColumnVector)vector, schema, row);
                        break block16;
                    }
                    case STRUCT: {
                        PrintData.printStruct(writer, (StructColumnVector)vector, schema, row);
                        break block16;
                    }
                    case UNION: {
                        PrintData.printUnion(writer, (UnionColumnVector)vector, schema, row);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + String.valueOf(schema));
                    }
                }
            }
            writer.nullValue();
        }
    }

    static void printRow(JsonWriter writer, VectorizedRowBatch batch, TypeDescription schema, int row) throws IOException {
        if (schema.getCategory() == TypeDescription.Category.STRUCT) {
            List fieldTypes = schema.getChildren();
            List fieldNames = schema.getFieldNames();
            writer.beginObject();
            for (int c = 0; c < batch.cols.length; ++c) {
                writer.name((String)fieldNames.get(c));
                PrintData.printValue(writer, batch.cols[c], (TypeDescription)fieldTypes.get(c), row);
            }
            writer.endObject();
        } else {
            PrintData.printValue(writer, batch.cols[0], schema, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printJsonData(PrintStream printStream, Reader reader, Optional<Integer> numberOfRows) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8);
        try (RecordReader rows = reader.rows();){
            TypeDescription schema = reader.getSchema();
            VectorizedRowBatch batch = schema.createRowBatch();
            Integer counter = 0;
            block3: while (rows.nextBatch(batch)) {
                if (numberOfRows.isPresent() && counter >= numberOfRows.get()) {
                    break;
                }
                for (int r = 0; r < batch.size; ++r) {
                    JsonWriter writer = new JsonWriter((Writer)out);
                    writer.setLenient(true);
                    PrintData.printRow(writer, batch, schema, r);
                    out.write("\n");
                    out.flush();
                    if (printStream.checkError()) {
                        throw new IOException("Error encountered when writing to stdout.");
                    }
                    if (!numberOfRows.isPresent()) continue;
                    Integer n = counter;
                    counter = counter + 1;
                    if (counter >= numberOfRows.get()) continue block3;
                }
            }
        }
    }

    private static Options getOptions() {
        Option help = Option.builder((String)"h").longOpt("help").hasArg(false).desc("Provide help").build();
        Option linesOpt = Option.builder((String)"n").longOpt("lines").argName("LINES").desc("Sets lines of data to be printed").hasArg().build();
        Options options = new Options().addOption(help).addOption(linesOpt);
        return options;
    }

    private static void printHelp() {
        Options opts = PrintData.getOptions();
        PrintWriter pw = new PrintWriter(System.err);
        new HelpFormatter().printHelp(pw, 74, "java -jar orc-tools-*.jar data <orc file>*", null, opts, 1, 3, null);
        pw.flush();
    }

    static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = PrintData.getOptions();
        return new DefaultParser().parse(options, args);
    }

    static void main(Configuration conf, String[] args) throws ParseException {
        CommandLine cli = PrintData.parseCommandLine(args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            PrintData.printHelp();
            System.exit(1);
        } else {
            Optional<Integer> lines = Optional.empty();
            if (cli.hasOption("n")) {
                lines = Optional.of(Integer.parseInt(cli.getOptionValue("n")));
            }
            ArrayList<String> badFiles = new ArrayList<String>();
            for (String file : cli.getArgs()) {
                try {
                    Path path = new Path(file);
                    Reader reader = FileDump.getReader(path, conf, badFiles);
                    if (reader == null) continue;
                    PrintData.printJsonData(System.out, reader, lines);
                    System.out.println(FileDump.SEPARATOR);
                }
                catch (Exception e) {
                    System.err.println("Unable to dump data for file: " + file);
                    e.printStackTrace();
                }
            }
        }
    }
}

