/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.topology;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class Node
implements Comparable<Node> {
    private String _name;
    private String _type;
    private long _id;
    private long _weight;
    private LinkedHashMap<String, Node> _children = new LinkedHashMap();
    private Node _parent;
    private boolean _failed;

    public Node() {
    }

    protected Node(Node node) {
        this._name = node.getName();
        this._type = node.getType();
        this._id = node.getId();
        this._weight = node.getWeight();
        this._failed = node.isFailed();
    }

    public Node clone() {
        return new Node(this);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public long getWeight() {
        return this._weight;
    }

    public void setWeight(long weight) {
        this._weight = weight;
    }

    public void addWeight(long weight) {
        this._weight += weight;
    }

    public boolean isFailed() {
        return this._failed;
    }

    public void setFailed(boolean failed) {
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException("you cannot set failed on a non-leaf!");
        }
        this._failed = failed;
    }

    public List<Node> getChildren() {
        return new ArrayList<Node>(this._children.values());
    }

    public void addChild(Node child) {
        this._children.put(child.getName(), child);
    }

    public boolean hasChild(String name) {
        return this._children.containsKey(name);
    }

    public Node getChild(String name) {
        return this._children.get(name);
    }

    public boolean isLeaf() {
        return this._children == null || this._children.isEmpty();
    }

    public Node getParent() {
        return this._parent;
    }

    public void setParent(Node parent) {
        this._parent = parent;
    }

    protected List<Node> findChildren(String type) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this._type.equalsIgnoreCase(type)) {
            nodes.add(this);
        } else if (!this.isLeaf()) {
            for (Node child : this._children.values()) {
                nodes.addAll(child.findChildren(type));
            }
        }
        return nodes;
    }

    public int getChildrenCount(String type) {
        int count = 0;
        if (this._type.equalsIgnoreCase(type)) {
            ++count;
        } else if (!this.isLeaf()) {
            for (Node child : this._children.values()) {
                count += child.getChildrenCount(type);
            }
        }
        return count;
    }

    public Node getRoot() {
        Node node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    public String toString() {
        return this._name + ":" + this._id;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node that = (Node)obj;
        return this._name.equals(that.getName());
    }

    @Override
    public int compareTo(Node o) {
        return this._name.compareTo(o.getName());
    }
}

