/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.Map;
import org.apache.helix.model.CurrentState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;

class CurStateCarryOverUpdater
implements DataUpdater<ZNRecord> {
    final String _curSessionId;
    final Map<String, String> _expectedStateMap;
    final CurrentState _lastCurState;

    public CurStateCarryOverUpdater(String curSessionId, Map<String, String> expectedStateMap, CurrentState lastCurState) {
        if (curSessionId == null || lastCurState == null) {
            throw new IllegalArgumentException("missing curSessionId|lastCurState for carry-over");
        }
        this._curSessionId = curSessionId;
        this._expectedStateMap = expectedStateMap;
        this._lastCurState = lastCurState;
    }

    @Override
    public ZNRecord update(ZNRecord currentData) {
        CurrentState curState;
        if (currentData == null) {
            curState = new CurrentState(this._lastCurState.getId());
            curState.getRecord().setSimpleFields(this._lastCurState.getRecord().getSimpleFields());
            curState.setSessionId(this._curSessionId);
        } else {
            curState = new CurrentState(currentData);
        }
        for (String partitionName : this._lastCurState.getPartitionStateMap().keySet()) {
            if (curState.getState(partitionName) != null) continue;
            curState.setState(partitionName, this._expectedStateMap.get(partitionName));
        }
        return curState.getRecord();
    }
}

