/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.Cache;
import org.apache.helix.manager.zk.GenericBaseDataAccessorBuilder;
import org.apache.helix.manager.zk.HelixGroupCommit;
import org.apache.helix.manager.zk.WriteThroughCache;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkCacheEventThread;
import org.apache.helix.manager.zk.ZkCallbackCache;
import org.apache.helix.store.HelixPropertyListener;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.store.zk.ZNode;
import org.apache.helix.util.PathUtils;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCacheBaseDataAccessor<T>
implements HelixPropertyStore<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ZkCacheBaseDataAccessor.class);
    protected WriteThroughCache<T> _wtCache;
    protected ZkCallbackCache<T> _zkCache;
    final ZkBaseDataAccessor<T> _baseAccessor;
    final Map<String, Cache<T>> _cacheMap = new TreeMap<String, Cache<T>>((o1, o2) -> {
        int len1 = o1.split("/").length;
        int len2 = o2.split("/").length;
        return len1 - len2;
    });
    final String _chrootPath;
    final List<String> _wtCachePaths;
    final List<String> _zkCachePaths;
    final HelixGroupCommit<T> _groupCommit = new HelixGroupCommit();
    private final ReentrantLock _eventLock = new ReentrantLock();
    private ZkCacheEventThread _eventThread;
    private RealmAwareZkClient _zkClient;

    @Deprecated
    public ZkCacheBaseDataAccessor(ZkBaseDataAccessor<T> baseAccessor, List<String> wtCachePaths) {
        this(baseAccessor, null, wtCachePaths, null);
    }

    @Deprecated
    public ZkCacheBaseDataAccessor(ZkBaseDataAccessor<T> baseAccessor, String chrootPath, List<String> wtCachePaths, List<String> zkCachePaths) {
        this._baseAccessor = baseAccessor;
        if (chrootPath == null || chrootPath.equals("/")) {
            this._chrootPath = null;
        } else {
            PathUtils.validatePath(chrootPath);
            this._chrootPath = chrootPath;
        }
        this._wtCachePaths = wtCachePaths;
        this._zkCachePaths = zkCachePaths;
        this.start();
    }

    @Deprecated
    public ZkCacheBaseDataAccessor(String zkAddress, ZkSerializer serializer, String chrootPath, List<String> wtCachePaths, List<String> zkCachePaths) {
        this(zkAddress, serializer, chrootPath, wtCachePaths, zkCachePaths, null, null, ZkBaseDataAccessor.ZkClientType.SHARED);
    }

    @Deprecated
    public ZkCacheBaseDataAccessor(String zkAddress, ZkSerializer serializer, String chrootPath, List<String> wtCachePaths, List<String> zkCachePaths, String monitorType, String monitorkey) {
        this(zkAddress, serializer, chrootPath, wtCachePaths, zkCachePaths, monitorType, monitorkey, ZkBaseDataAccessor.ZkClientType.SHARED);
    }

    @Deprecated
    public ZkCacheBaseDataAccessor(String zkAddress, ZkSerializer serializer, String chrootPath, List<String> wtCachePaths, List<String> zkCachePaths, String monitorType, String monitorkey, ZkBaseDataAccessor.ZkClientType zkClientType) {
        this._zkClient = ZkBaseDataAccessor.buildRealmAwareZkClientWithDefaultConfigs(new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(serializer).setMonitorType(monitorType).setMonitorKey(monitorkey), zkAddress, zkClientType);
        this._baseAccessor = new ZkBaseDataAccessor(this._zkClient);
        if (chrootPath == null || chrootPath.equals("/")) {
            this._chrootPath = null;
        } else {
            PathUtils.validatePath(chrootPath);
            this._chrootPath = chrootPath;
        }
        this._wtCachePaths = wtCachePaths;
        this._zkCachePaths = zkCachePaths;
        this.start();
    }

    private ZkCacheBaseDataAccessor(RealmAwareZkClient zkClient, String chrootPath, List<String> wtCachePaths, List<String> zkCachePaths) {
        this._zkClient = zkClient;
        this._baseAccessor = new ZkBaseDataAccessor(this._zkClient);
        this._chrootPath = chrootPath;
        this._wtCachePaths = wtCachePaths;
        this._zkCachePaths = zkCachePaths;
        this.start();
    }

    private String prependChroot(String clientPath) {
        PathUtils.validatePath(clientPath);
        if (this._chrootPath != null) {
            if (clientPath.length() == 1) {
                return this._chrootPath;
            }
            return this._chrootPath + clientPath;
        }
        return clientPath;
    }

    private List<String> prependChroot(List<String> clientPaths) {
        ArrayList<String> serverPaths = new ArrayList<String>();
        for (String clientPath : clientPaths) {
            serverPaths.add(this.prependChroot(clientPath));
        }
        return serverPaths;
    }

    private String firstCachePath(List<String> paths) {
        for (String cachePath : this._cacheMap.keySet()) {
            for (String path : paths) {
                if (!path.startsWith(cachePath)) continue;
                return path;
            }
        }
        return null;
    }

    private Cache<T> getCache(String path) {
        for (String cachePath : this._cacheMap.keySet()) {
            if (!path.startsWith(cachePath)) continue;
            return this._cacheMap.get(cachePath);
        }
        return null;
    }

    private Cache<T> getCache(List<String> paths) {
        Cache<T> cache = null;
        for (String path : paths) {
            for (String cachePath : this._cacheMap.keySet()) {
                if (cache == null && path.startsWith(cachePath)) {
                    cache = this._cacheMap.get(cachePath);
                    continue;
                }
                if (cache == null || cache == this._cacheMap.get(cachePath)) continue;
                throw new IllegalArgumentException("Couldn't do cross-cache async operations. paths: " + paths);
            }
        }
        return cache;
    }

    private void updateCache(Cache<T> cache, List<String> createPaths, boolean success, String updatePath, T data, Stat stat) {
        if (createPaths == null || createPaths.isEmpty()) {
            if (success) {
                cache.update(updatePath, data, stat);
            }
        } else {
            String firstPath = this.firstCachePath(createPaths);
            if (firstPath != null) {
                cache.updateRecursive(firstPath);
            }
        }
    }

    @Override
    public boolean create(String path, T data, int options) {
        return this.create(path, data, options, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String path, T data, int options, long ttl) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        if (cache != null) {
            try {
                cache.lockWrite();
                ZkBaseDataAccessor.AccessResult result = this._baseAccessor.doCreate(serverPath, data, options, ttl);
                boolean success = result._retCode == ZkBaseDataAccessor.RetCode.OK;
                this.updateCache(cache, result._pathCreated, success, serverPath, data, ZNode.ZERO_STAT);
                boolean bl = success;
                return bl;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.create(serverPath, data, options, ttl);
    }

    @Override
    public boolean set(String path, T data, int options) {
        return this.set(path, data, -1, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(String path, T data, int expectVersion, int options) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        boolean success = false;
        try {
            if (cache != null) {
                cache.lockWrite();
                ZkBaseDataAccessor.AccessResult result = this._baseAccessor.doSet(serverPath, data, expectVersion, options);
                success = result._retCode == ZkBaseDataAccessor.RetCode.OK;
                this.updateCache(cache, result._pathCreated, success, serverPath, data, result._stat);
            } else {
                success = this._baseAccessor.set(serverPath, data, expectVersion, options);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cache != null) {
                cache.unlockWrite();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(String path, DataUpdater<T> updater, int options) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        if (cache != null) {
            try {
                cache.lockWrite();
                ZkBaseDataAccessor.AccessResult result = this._baseAccessor.doUpdate(serverPath, updater, options);
                boolean success = result._retCode == ZkBaseDataAccessor.RetCode.OK;
                this.updateCache(cache, result._pathCreated, success, serverPath, result._updatedValue, result._stat);
                boolean bl = success;
                return bl;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._groupCommit.commit(this._baseAccessor, options, serverPath, updater);
    }

    @Override
    public boolean exists(String path, int options) {
        boolean exists;
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        if (cache != null && (exists = cache.exists(serverPath))) {
            return true;
        }
        return this._baseAccessor.exists(serverPath, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String path, int options) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        if (cache != null) {
            try {
                cache.lockWrite();
                boolean success = this._baseAccessor.remove(serverPath, options);
                if (success) {
                    cache.purgeRecursive(serverPath);
                }
                boolean bl = success;
                return bl;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.remove(serverPath, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(String path, Stat stat, int options) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<Object> cache = this.getCache(serverPath);
        if (cache != null) {
            Object record = null;
            ZNode znode = cache.get(serverPath);
            if (znode != null) {
                record = znode.getData();
                if (stat != null) {
                    DataTree.copyStat((Stat)znode.getStat(), (Stat)stat);
                }
                return (T)record;
            }
            try {
                cache.lockWrite();
                record = this._baseAccessor.get(serverPath, stat, options | AccessOption.THROW_EXCEPTION_IFNOTEXIST);
                cache.update(serverPath, record, stat);
            }
            catch (ZkNoNodeException e) {
                if (AccessOption.isThrowExceptionIfNotExist(options)) {
                    throw e;
                }
            }
            finally {
                cache.unlockWrite();
            }
            return (T)record;
        }
        return this._baseAccessor.get(serverPath, stat, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stat getStat(String path, int options) {
        String clientPath = path;
        String serverPath = this.prependChroot(clientPath);
        Cache<T> cache = this.getCache(serverPath);
        if (cache != null) {
            Stat stat = new Stat();
            ZNode znode = cache.get(serverPath);
            if (znode != null) {
                return znode.getStat();
            }
            try {
                cache.lockWrite();
                T data = this._baseAccessor.get(serverPath, stat, options);
                cache.update(serverPath, data, stat);
            }
            catch (ZkNoNodeException e) {
                Stat stat2 = null;
                return stat2;
            }
            finally {
                cache.unlockWrite();
            }
            return stat;
        }
        return this._baseAccessor.getStat(serverPath, options);
    }

    @Override
    public boolean[] createChildren(List<String> paths, List<T> records, int options) {
        return this.createChildren(paths, records, options, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] createChildren(List<String> paths, List<T> records, int options, long ttl) {
        int size = paths.size();
        List<String> serverPaths = this.prependChroot(paths);
        Cache<T> cache = this.getCache(serverPaths);
        if (cache != null) {
            try {
                cache.lockWrite();
                boolean[] needCreate = new boolean[size];
                Arrays.fill(needCreate, true);
                ArrayList<Object> pathsCreatedList = new ArrayList<Object>(Collections.nCopies(size, null));
                ZkAsyncCallbacks.CreateCallbackHandler[] createCbList = this._baseAccessor.create(serverPaths, records, needCreate, pathsCreatedList, options, ttl);
                boolean[] success = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ZkAsyncCallbacks.CreateCallbackHandler cb = createCbList[i];
                    success[i] = KeeperException.Code.get((int)cb.getRc()) == KeeperException.Code.OK;
                    this.updateCache(cache, (List)pathsCreatedList.get(i), success[i], serverPaths.get(i), records.get(i), ZNode.ZERO_STAT);
                }
                boolean[] blArray = success;
                return blArray;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.createChildren(serverPaths, records, options, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] setChildren(List<String> paths, List<T> records, int options) {
        int size = paths.size();
        List<String> serverPaths = this.prependChroot(paths);
        Cache<T> cache = this.getCache(serverPaths);
        if (cache != null) {
            try {
                cache.lockWrite();
                ArrayList<Stat> setStats = new ArrayList<Stat>();
                ArrayList<Object> pathsCreatedList = new ArrayList<Object>(Collections.nCopies(size, null));
                boolean[] success = this._baseAccessor.set(serverPaths, records, pathsCreatedList, setStats, options);
                for (int i = 0; i < size; ++i) {
                    this.updateCache(cache, (List)pathsCreatedList.get(i), success[i], serverPaths.get(i), records.get(i), (Stat)setStats.get(i));
                }
                boolean[] blArray = success;
                return blArray;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.setChildren(serverPaths, records, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] updateChildren(List<String> paths, List<DataUpdater<T>> updaters, int options) {
        int size = paths.size();
        List<String> serverPaths = this.prependChroot(paths);
        Cache<T> cache = this.getCache(serverPaths);
        if (cache != null) {
            try {
                cache.lockWrite();
                ArrayList<Stat> setStats = new ArrayList<Stat>();
                boolean[] success = new boolean[size];
                ArrayList<Object> pathsCreatedList = new ArrayList<Object>(Collections.nCopies(size, null));
                List<T> updateData = this._baseAccessor.update(serverPaths, updaters, pathsCreatedList, setStats, options);
                for (int i = 0; i < size; ++i) {
                    success[i] = updateData.get(i) != null;
                    this.updateCache(cache, (List)pathsCreatedList.get(i), success[i], serverPaths.get(i), updateData.get(i), (Stat)setStats.get(i));
                }
                boolean[] blArray = success;
                return blArray;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.updateChildren(serverPaths, updaters, options);
    }

    @Override
    public boolean[] exists(List<String> paths, int options) {
        int size = paths.size();
        boolean[] exists = new boolean[size];
        for (int i = 0; i < size; ++i) {
            exists[i] = this.exists(paths.get(i), options);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] remove(List<String> paths, int options) {
        int size = paths.size();
        List<String> serverPaths = this.prependChroot(paths);
        Cache<T> cache = this.getCache(serverPaths);
        if (cache != null) {
            try {
                cache.lockWrite();
                boolean[] success = this._baseAccessor.remove(serverPaths, options);
                for (int i = 0; i < size; ++i) {
                    if (!success[i]) continue;
                    cache.purgeRecursive(serverPaths.get(i));
                }
                boolean[] blArray = success;
                return blArray;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.remove(serverPaths, options);
    }

    @Override
    @Deprecated
    public List<T> get(List<String> paths, List<Stat> stats, int options) {
        return this.get(paths, stats, options, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> get(List<String> paths, List<Stat> stats, int options, boolean throwException) throws HelixException {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        int size = paths.size();
        List<String> serverPaths = this.prependChroot(paths);
        ArrayList<Object> records = new ArrayList<Object>(Collections.nCopies(size, null));
        ArrayList<Object> readStats = new ArrayList<Object>(Collections.nCopies(size, null));
        boolean needRead = false;
        boolean[] needReads = new boolean[size];
        Cache<T> cache = this.getCache(serverPaths);
        if (cache != null) {
            try {
                cache.lockRead();
                for (int i = 0; i < size; ++i) {
                    ZNode zNode = cache.get(serverPaths.get(i));
                    if (zNode != null) {
                        records.set(i, zNode.getData());
                        readStats.set(i, zNode.getStat());
                        continue;
                    }
                    needRead = true;
                    needReads[i] = true;
                }
            }
            finally {
                cache.unlockRead();
            }
            if (needRead) {
                cache.lockWrite();
                try {
                    List<T> readRecords = this._baseAccessor.get(serverPaths, readStats, needReads, throwException);
                    for (int i = 0; i < size; ++i) {
                        if (!needReads[i]) continue;
                        records.set(i, readRecords.get(i));
                        cache.update(serverPaths.get(i), readRecords.get(i), (Stat)readStats.get(i));
                    }
                }
                finally {
                    cache.unlockWrite();
                }
            }
            if (stats != null) {
                stats.clear();
                stats.addAll(readStats);
            }
            return records;
        }
        return this._baseAccessor.get(serverPaths, stats, options, throwException);
    }

    @Override
    public Stat[] getStats(List<String> paths, int options) {
        List<String> serverPaths = this.prependChroot(paths);
        return this._baseAccessor.getStats(serverPaths, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getChildNames(String parentPath, int options) {
        String serverParentPath = this.prependChroot(parentPath);
        Cache<T> cache = this.getCache(serverParentPath);
        if (cache != null) {
            ZNode znode = cache.get(serverParentPath);
            if (znode != null && znode.getChildSet() != Collections.emptySet()) {
                ArrayList<String> childNames = new ArrayList<String>(znode.getChildSet());
                Collections.sort(childNames);
                return childNames;
            }
            try {
                cache.lockWrite();
                List<String> childNames = this._baseAccessor.getChildNames(serverParentPath, options);
                cache.addToParentChildSet(serverParentPath, childNames);
                List<String> list = childNames;
                return list;
            }
            finally {
                cache.unlockWrite();
            }
        }
        return this._baseAccessor.getChildNames(serverParentPath, options);
    }

    @Override
    @Deprecated
    public List<T> getChildren(String parentPath, List<Stat> stats, int options) {
        return this.getChildren(parentPath, stats, options, false);
    }

    @Override
    public List<T> getChildren(String parentPath, List<Stat> stats, int options, int retryCount, int retryInterval) throws HelixException {
        return this.getChildren(parentPath, stats, options, true);
    }

    private List<T> getChildren(String parentPath, List<Stat> stats, int options, boolean throwException) {
        List<String> childNames = this.getChildNames(parentPath, options);
        if (childNames == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String childName : childNames) {
            String path = parentPath.equals("/") ? "/" + childName : parentPath + "/" + childName;
            paths.add(path);
        }
        return this.get(paths, stats, options, throwException);
    }

    @Override
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        String serverPath = this.prependChroot(path);
        this._baseAccessor.subscribeDataChanges(serverPath, listener);
    }

    @Override
    public void unsubscribeDataChanges(String path, IZkDataListener listener) {
        String serverPath = this.prependChroot(path);
        this._baseAccessor.unsubscribeDataChanges(serverPath, listener);
    }

    @Override
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        String serverPath = this.prependChroot(path);
        return this._baseAccessor.subscribeChildChanges(serverPath, listener);
    }

    @Override
    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        String serverPath = this.prependChroot(path);
        this._baseAccessor.unsubscribeChildChanges(serverPath, listener);
    }

    @Override
    public void subscribe(String parentPath, HelixPropertyListener listener) {
        String serverPath = this.prependChroot(parentPath);
        this._zkCache.subscribe(serverPath, listener);
    }

    @Override
    public void unsubscribe(String parentPath, HelixPropertyListener listener) {
        String serverPath = this.prependChroot(parentPath);
        this._zkCache.unsubscribe(serverPath, listener);
    }

    @Override
    public void start() {
        LOG.info("START: Init ZkCacheBaseDataAccessor: " + this._chrootPath + ", " + this._wtCachePaths + ", " + this._zkCachePaths);
        try {
            this._eventLock.lockInterruptibly();
            if (this._eventThread != null) {
                LOG.warn(this._eventThread + " has already started");
            } else if (this._zkCachePaths == null || this._zkCachePaths.isEmpty()) {
                LOG.warn("ZkCachePaths is null or empty. Will not start ZkCacheEventThread");
            } else {
                LOG.debug("Starting ZkCacheEventThread...");
                this._eventThread = new ZkCacheEventThread("");
                this._eventThread.start();
            }
        }
        catch (InterruptedException e) {
            throw new HelixException("Current thread is interrupted when acquiring lock. ", e);
        }
        finally {
            this._eventLock.unlock();
        }
        LOG.debug("Start ZkCacheEventThread...done");
        this._wtCache = new WriteThroughCache<T>(this._baseAccessor, this._wtCachePaths);
        this._zkCache = new ZkCallbackCache<T>(this._baseAccessor, this._chrootPath, this._zkCachePaths, this._eventThread);
        if (this._wtCachePaths != null && !this._wtCachePaths.isEmpty()) {
            for (String path : this._wtCachePaths) {
                this._cacheMap.put(path, this._wtCache);
            }
        }
        if (this._zkCachePaths != null && !this._zkCachePaths.isEmpty()) {
            for (String path : this._zkCachePaths) {
                this._cacheMap.put(path, this._zkCache);
            }
        }
    }

    @Override
    public void stop() {
        try {
            this._eventLock.lockInterruptibly();
            if (this._zkClient != null) {
                this._zkClient.close();
                this._zkClient = null;
            }
            if (this._eventThread == null) {
                LOG.warn(this._eventThread + " has already stopped");
                return;
            }
            LOG.debug("Stopping ZkCacheEventThread...");
            this._eventThread.interrupt();
            this._eventThread.join(2000L);
            this._eventThread = null;
        }
        catch (InterruptedException e) {
            LOG.error("Current thread is interrupted when stopping ZkCacheEventThread.");
        }
        finally {
            this._eventLock.unlock();
        }
        LOG.debug("Stop ZkCacheEventThread...done");
    }

    @Override
    public void reset() {
        if (this._wtCache != null) {
            this._wtCache.reset();
        }
        if (this._zkCache != null) {
            this._zkCache.reset();
        }
    }

    @Override
    public void close() {
        if (this._zkClient != null) {
            this._zkClient.close();
        }
    }

    public void finalize() {
        this.close();
    }

    public static class Builder<T>
    extends GenericBaseDataAccessorBuilder<Builder<T>> {
        private String _chrootPath;
        private List<String> _wtCachePaths;
        private List<String> _zkCachePaths;

        public Builder<T> setChrootPath(String chrootPath) {
            this._chrootPath = chrootPath;
            return this;
        }

        public Builder<T> setWtCachePaths(List<String> wtCachePaths) {
            this._wtCachePaths = wtCachePaths;
            return this;
        }

        public Builder<T> setZkCachePaths(List<String> zkCachePaths) {
            this._zkCachePaths = zkCachePaths;
            return this;
        }

        public ZkCacheBaseDataAccessor<T> build() {
            this.validate();
            return new ZkCacheBaseDataAccessor(this.createZkClient(this._realmMode, this._realmAwareZkConnectionConfig, this._realmAwareZkClientConfig, this._zkAddress), this._chrootPath, this._wtCachePaths, this._zkCachePaths);
        }
    }
}

