/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedState
extends HelixProperty {
    private static Logger LOG = LoggerFactory.getLogger(CustomizedState.class);

    public CustomizedState(String resourceName) {
        super(resourceName);
    }

    public CustomizedState(ZNRecord record) {
        super(record);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public Map<String, String> getPartitionStateMap(CustomizedStateProperty property) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        for (String partitionName : mapFields.keySet()) {
            Map<String, String> tempMap = mapFields.get(partitionName);
            if (tempMap == null) continue;
            map.put(partitionName, tempMap.get(property.name()));
        }
        return map;
    }

    public String getState(String partitionName) {
        return this.getProperty(partitionName, CustomizedStateProperty.CURRENT_STATE);
    }

    public long getStartTime(String partitionName) {
        String startTime = this.getProperty(partitionName, CustomizedStateProperty.START_TIME);
        return startTime == null ? -1L : Long.parseLong(startTime);
    }

    public long getEndTime(String partitionName) {
        String endTime = this.getProperty(partitionName, CustomizedStateProperty.END_TIME);
        return endTime == null ? -1L : Long.parseLong(endTime);
    }

    public String getPreviousState(String partitionName) {
        return this.getProperty(partitionName, CustomizedStateProperty.PREVIOUS_STATE);
    }

    private String getProperty(String partitionName, CustomizedStateProperty property) {
        Map<String, String> mapField = this._record.getMapField(partitionName);
        if (mapField != null) {
            return mapField.get(property.name());
        }
        return null;
    }

    public void setState(String partitionName, String state) {
        this.setProperty(partitionName, CustomizedStateProperty.CURRENT_STATE, state);
    }

    public void setStartTime(String partitionName, long startTime) {
        this.setProperty(partitionName, CustomizedStateProperty.START_TIME, String.valueOf(startTime));
    }

    public void setEndTime(String partitionName, long endTime) {
        this.setProperty(partitionName, CustomizedStateProperty.END_TIME, String.valueOf(endTime));
    }

    public void setPreviousState(String partitionName, String state) {
        this.setProperty(partitionName, CustomizedStateProperty.PREVIOUS_STATE, state);
    }

    private void setProperty(String partitionName, CustomizedStateProperty property, String value) {
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        mapFields.putIfAbsent(partitionName, new TreeMap());
        mapFields.get(partitionName).put(property.name(), value);
    }

    @Override
    public boolean isValid() {
        if (this.getPartitionStateMap(CustomizedStateProperty.CURRENT_STATE) == null) {
            LOG.error("Customized state does not contain state map. id:" + this.getResourceName());
            return false;
        }
        return true;
    }

    public static enum CustomizedStateProperty {
        PREVIOUS_STATE,
        CURRENT_STATE,
        START_TIME,
        END_TIME;

    }
}

