/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Map;
import org.apache.helix.controller.rebalancer.waged.constraints.AbstractPartitionMovementConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

public class PartitionMovementConstraint
extends AbstractPartitionMovementConstraint {
    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        Map<String, String> bestPossibleAssignment = this.getStateMap(replica, clusterContext.getBestPossibleAssignment());
        Map<String, String> baselineAssignment = this.getStateMap(replica, clusterContext.getBaselineAssignment());
        String nodeName = node.getInstanceName();
        String state = replica.getReplicaState();
        if (bestPossibleAssignment.isEmpty()) {
            return this.calculateAssignmentScore(nodeName, state, baselineAssignment);
        }
        return this.calculateAssignmentScore(nodeName, state, bestPossibleAssignment);
    }
}

