/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.rebalancer.util.ResourceUsageCalculator;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.WagedInstanceCapacity;
import org.apache.helix.controller.rebalancer.waged.WagedResourceWeightsProvider;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(CurrentStateComputationStage.class);
    private boolean _isTaskFrameworkPipeline = false;

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (cache instanceof WorkflowControllerDataProvider) {
            this._isTaskFrameworkPipeline = true;
        }
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        Map resourceToRebalance = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        if (cache == null || resourceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        CurrentStateOutput currentStateOutput = new CurrentStateOutput();
        for (LiveInstance instance : liveInstances.values()) {
            String instanceName = instance.getInstanceName();
            String instanceSessionId = instance.getEphemeralOwner();
            this.updateCurrentStates(instance, cache.getCurrentState(instanceName, instanceSessionId, this._isTaskFrameworkPipeline).values(), currentStateOutput, resourceMap);
            Set<Message> existingStaleMessages = cache.getStaleMessagesByInstance(instanceName);
            Map<String, Message> messages = cache.getMessages(instanceName);
            Map<String, Message> relayMessages = cache.getRelayMessages(instanceName);
            this.updatePendingMessages(instance, cache, messages.values(), relayMessages.values(), existingStaleMessages, currentStateOutput, resourceMap);
        }
        event.addAttribute(AttributeName.CURRENT_STATE.name(), currentStateOutput);
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        if (clusterStatusMonitor != null && cache instanceof ResourceControllerDataProvider) {
            ResourceControllerDataProvider dataProvider = (ResourceControllerDataProvider)cache;
            this.reportInstanceCapacityMetrics(clusterStatusMonitor, dataProvider, resourceToRebalance, currentStateOutput);
            this.reportResourcePartitionCapacityMetrics(dataProvider.getAsyncTasksThreadPool(), clusterStatusMonitor, dataProvider.getResourceConfigMap().values());
            WagedInstanceCapacity capacityProvider = new WagedInstanceCapacity(dataProvider);
            WagedResourceWeightsProvider weightProvider = new WagedResourceWeightsProvider(dataProvider);
            capacityProvider.process(dataProvider, currentStateOutput, resourceMap, weightProvider);
            dataProvider.setWagedCapacityProviders(capacityProvider, weightProvider);
        }
    }

    private void updatePendingMessages(LiveInstance instance, BaseControllerDataProvider cache, Collection<Message> pendingMessages, Collection<Message> pendingRelayMessages, Set<Message> existingStaleMessages, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap) {
        Object partition;
        String partitionName;
        Resource resource;
        String resourceName;
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getEphemeralOwner();
        for (Message message : pendingMessages) {
            if (existingStaleMessages.contains(message) || !Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType()) && !Message.MessageType.STATE_TRANSITION_CANCELLATION.name().equalsIgnoreCase(message.getMsgType()) || !instanceSessionId.equals(message.getTgtSessionId())) continue;
            resourceName = message.getResourceName();
            resource = resourceMap.get(resourceName);
            if (resource == null) {
                LogUtil.logDebug(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            if (!message.getBatchMessageMode()) {
                partitionName = message.getPartitionName();
                partition = resource.getPartition(partitionName);
                if (partition != null) {
                    String currentState = currentStateOutput.getCurrentState(resourceName, (Partition)partition, instanceName);
                    if (this._isTaskFrameworkPipeline || !this.isStaleMessage(message, currentState)) {
                        this.setMessageState(currentStateOutput, resourceName, (Partition)partition, instanceName, message);
                    } else {
                        cache.addStaleMessage(instanceName, message);
                    }
                } else {
                    LogUtil.logDebug(LOG, this._eventId, String.format("Ignore a pending message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                }
            } else {
                List<String> partitionNames = message.getPartitionNames();
                if (!partitionNames.isEmpty()) {
                    for (String partitionName2 : partitionNames) {
                        Partition partition2 = resource.getPartition(partitionName2);
                        if (partition2 != null) {
                            this.setMessageState(currentStateOutput, resourceName, partition2, instanceName, message);
                            continue;
                        }
                        LogUtil.logDebug(LOG, this._eventId, String.format("Ignore a pending message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                    }
                }
            }
            if (resource.getStateModelDefRef() == null) continue;
            currentStateOutput.setResourceStateModelDef(resourceName, resource.getStateModelDefRef());
        }
        for (Message message : pendingRelayMessages) {
            if (!message.isRelayMessage()) {
                LogUtil.logWarn(LOG, this._eventId, String.format("Not a relay message %s, ignored!", message.getMsgId()));
                continue;
            }
            resourceName = message.getResourceName();
            resource = resourceMap.get(resourceName);
            if (resource == null) {
                LogUtil.logDebug(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            if (!message.getBatchMessageMode()) {
                partitionName = message.getPartitionName();
                partition = resource.getPartition(partitionName);
                if (partition != null) {
                    currentStateOutput.setPendingRelayMessage(resourceName, (Partition)partition, instanceName, message);
                    continue;
                }
                LogUtil.logDebug(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            LogUtil.logWarn(LOG, this._eventId, String.format("A relay message %s should not be batched, ignored!", message.getMsgId()));
        }
    }

    private boolean isStaleMessage(Message message, String currentState) {
        if (currentState == null || message.getFromState() == null || message.getToState() == null) {
            return false;
        }
        return !message.getFromState().equalsIgnoreCase(currentState) || message.getToState().equalsIgnoreCase(currentState);
    }

    private void updateCurrentStates(LiveInstance instance, Collection<CurrentState> currentStates, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap) {
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getEphemeralOwner();
        for (CurrentState currentState : currentStates) {
            if (!instanceSessionId.equals(currentState.getSessionId())) continue;
            String resourceName = currentState.getResourceName();
            String stateModelDefName = currentState.getStateModelDefRef();
            Resource resource = resourceMap.get(resourceName);
            if (resource == null) continue;
            if (stateModelDefName != null) {
                currentStateOutput.setResourceStateModelDef(resourceName, stateModelDefName);
            }
            currentStateOutput.setBucketSize(resourceName, currentState.getBucketSize());
            Map<String, String> partitionStateMap = currentState.getPartitionStateMap();
            for (String partitionName : partitionStateMap.keySet()) {
                String requestState;
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                currentStateOutput.setCurrentState(resourceName, partition, instanceName, currentState.getState(partitionName));
                currentStateOutput.setEndTime(resourceName, partition, instanceName, currentState.getEndTime(partitionName));
                String info = currentState.getInfo(partitionName);
                if (info != null) {
                    currentStateOutput.setInfo(resourceName, partition, instanceName, info);
                }
                if ((requestState = currentState.getRequestedState(partitionName)) == null) continue;
                currentStateOutput.setRequestedState(resourceName, partition, instanceName, requestState);
            }
        }
    }

    private void setMessageState(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, String instanceName, Message message) {
        if (Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType())) {
            currentStateOutput.setPendingMessage(resourceName, partition, instanceName, message);
        } else {
            currentStateOutput.setCancellationMessage(resourceName, partition, instanceName, message);
        }
    }

    private void reportInstanceCapacityMetrics(ClusterStatusMonitor clusterStatusMonitor, ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        CurrentStateComputationStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), () -> {
            try {
                Map<String, IdealState> idealStateMap = dataProvider.getIdealStates();
                Map<String, Resource> resourceToMonitorMap = resourceMap.entrySet().stream().filter(entry -> WagedValidationUtil.isWagedEnabled((IdealState)idealStateMap.get(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map<String, ResourceAssignment> currentStateAssignment = currentStateOutput.getAssignment(resourceToMonitorMap.keySet());
                ClusterModel clusterModel = ClusterModelProvider.generateClusterModelFromExistingAssignment(dataProvider, resourceToMonitorMap, currentStateAssignment);
                for (AssignableNode node : clusterModel.getAssignableNodes().values()) {
                    String instanceName = node.getInstanceName();
                    double usage = node.getGeneralProjectedHighestUtilization(Collections.emptyMap());
                    clusterStatusMonitor.updateInstanceCapacityStatus(instanceName, usage, node.getMaxCapacity());
                }
            }
            catch (Exception ex) {
                LOG.error("Failed to report instance capacity metrics. Exception message: {}", (Object)ex.getMessage());
            }
            return null;
        });
    }

    private void reportResourcePartitionCapacityMetrics(ExecutorService executorService, ClusterStatusMonitor clusterStatusMonitor, Collection<ResourceConfig> resourceConfigs) {
        CurrentStateComputationStage.asyncExecute(executorService, () -> {
            try {
                for (ResourceConfig config : resourceConfigs) {
                    Map<String, Integer> averageWeight = ResourceUsageCalculator.calculateAveragePartitionWeight(config.getPartitionCapacityMap());
                    clusterStatusMonitor.updatePartitionWeight(config.getResourceName(), averageWeight);
                }
            }
            catch (Exception ex) {
                LOG.error("Failed to report resource partition capacity metrics. Exception message: {}", (Object)ex.getMessage());
            }
            return null;
        });
    }
}

