/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.UUID;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;

public class MessagePoster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(String zkServer, Message message, String clusterName, String instanceName) {
        try (HelixZkClient client = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkServer));){
            client.setZkSerializer(new ZNRecordSerializer());
            String path = PropertyPathBuilder.instanceMessage(clusterName, instanceName, message.getId());
            client.delete(path);
            ZNRecord record = (ZNRecord)client.readData(PropertyPathBuilder.liveInstance(clusterName, instanceName));
            message.setTgtSessionId(record.getSimpleField(LiveInstance.LiveInstanceProperty.SESSION_ID.toString()));
            message.setTgtName(record.getId());
            client.createPersistent(path, message.getRecord());
        }
    }

    public void postFaultInjectionMessage(String zkServer, String clusterName, String instanceName, String payloadString, String partition) {
        Message message = new Message("FaultInjection", UUID.randomUUID().toString());
        if (payloadString != null) {
            message.getRecord().setSimpleField("faultType", payloadString);
        }
        if (partition != null) {
            message.setPartitionName(partition);
        }
        this.post(zkServer, message, clusterName, instanceName);
    }

    public void postTestMessage(String zkServer, String clusterName, String instanceName) {
        String msgSrc = "cm-instance-0";
        String msgId = "TestMessageId-2";
        Message message = new Message(Message.MessageType.STATE_TRANSITION, msgId);
        message.setMsgId(msgId);
        message.setSrcName(msgSrc);
        message.setTgtName(instanceName);
        message.setMsgState(Message.MessageState.NEW);
        message.setFromState("Slave");
        message.setToState("Master");
        message.setPartitionName("EspressoDB.partition-0." + instanceName);
        this.post(zkServer, message, clusterName, instanceName);
    }

    public static void main(String[] args) {
        if (args.length < 4 || args.length > 6) {
            System.err.println("Usage: java " + MessagePoster.class.getName() + " zkServer cluster instance msgType [payloadString] [partition]");
            System.err.println("msgType can be one of test, fault");
            System.err.println("payloadString is sent along with the fault msgType");
            System.exit(1);
        }
        String zkServer = args[0];
        String cluster = args[1];
        String instance = args[2];
        String msgType = args[3];
        String payloadString = args.length >= 5 ? args[4] : null;
        String partition = args.length == 6 ? args[5] : null;
        MessagePoster messagePoster = new MessagePoster();
        if (msgType.equals("test")) {
            messagePoster.postTestMessage(zkServer, cluster, instance);
        } else if (msgType.equals("fault")) {
            messagePoster.postFaultInjectionMessage(zkServer, cluster, instance, payloadString, partition);
            System.out.println("Posted " + msgType);
        } else {
            System.err.println("Message was not posted. Unknown msgType:" + msgType);
        }
    }
}

